package zio.aws.ivschat
import zio.prelude.Subtype
import java.time.Instant
import zio.aws.ivschat.model.primitives.{
  TagValue,
  TagKey,
  LoggingConfigurationIdentifier
}
import zio.aws.ivschat.model.primitives.LogGroupName.Type
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object BucketName extends Subtype[String]
    type BucketName = zio.aws.ivschat.model.primitives.BucketName.Type
    object ChatToken extends Subtype[String]
    type ChatToken = zio.aws.ivschat.model.primitives.ChatToken.Type
    object DeliveryStreamName extends Subtype[String]
    type DeliveryStreamName =
      zio.aws.ivschat.model.primitives.DeliveryStreamName.Type
    object EventName extends Subtype[String]
    type EventName = zio.aws.ivschat.model.primitives.EventName.Type
    object ID extends Subtype[String]
    type ID = zio.aws.ivschat.model.primitives.ID.Type
    object LambdaArn extends Subtype[String]
    type LambdaArn = zio.aws.ivschat.model.primitives.LambdaArn.Type
    object LogGroupName extends Subtype[String]
    type LogGroupName = zio.aws.ivschat.model.primitives.LogGroupName.Type
    object LoggingConfigurationArn extends Subtype[String]
    type LoggingConfigurationArn =
      zio.aws.ivschat.model.primitives.LoggingConfigurationArn.Type
    object LoggingConfigurationID extends Subtype[String]
    type LoggingConfigurationID =
      zio.aws.ivschat.model.primitives.LoggingConfigurationID.Type
    object LoggingConfigurationIdentifier extends Subtype[String]
    type LoggingConfigurationIdentifier =
      zio.aws.ivschat.model.primitives.LoggingConfigurationIdentifier.Type
    object LoggingConfigurationName extends Subtype[String]
    type LoggingConfigurationName =
      zio.aws.ivschat.model.primitives.LoggingConfigurationName.Type
    object MaxLoggingConfigurationResults extends Subtype[Int]
    type MaxLoggingConfigurationResults =
      zio.aws.ivschat.model.primitives.MaxLoggingConfigurationResults.Type
    object MaxRoomResults extends Subtype[Int]
    type MaxRoomResults = zio.aws.ivschat.model.primitives.MaxRoomResults.Type
    object MessageID extends Subtype[String]
    type MessageID = zio.aws.ivschat.model.primitives.MessageID.Type
    object PaginationToken extends Subtype[String]
    type PaginationToken = zio.aws.ivschat.model.primitives.PaginationToken.Type
    object Reason extends Subtype[String]
    type Reason = zio.aws.ivschat.model.primitives.Reason.Type
    object ResourceArn extends Subtype[String]
    type ResourceArn = zio.aws.ivschat.model.primitives.ResourceArn.Type
    object RoomArn extends Subtype[String]
    type RoomArn = zio.aws.ivschat.model.primitives.RoomArn.Type
    object RoomID extends Subtype[String]
    type RoomID = zio.aws.ivschat.model.primitives.RoomID.Type
    object RoomIdentifier extends Subtype[String]
    type RoomIdentifier = zio.aws.ivschat.model.primitives.RoomIdentifier.Type
    object RoomMaxMessageLength extends Subtype[Int]
    type RoomMaxMessageLength =
      zio.aws.ivschat.model.primitives.RoomMaxMessageLength.Type
    object RoomMaxMessageRatePerSecond extends Subtype[Int]
    type RoomMaxMessageRatePerSecond =
      zio.aws.ivschat.model.primitives.RoomMaxMessageRatePerSecond.Type
    object RoomName extends Subtype[String]
    type RoomName = zio.aws.ivschat.model.primitives.RoomName.Type
    object SessionDurationInMinutes extends Subtype[Int]
    type SessionDurationInMinutes =
      zio.aws.ivschat.model.primitives.SessionDurationInMinutes.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.ivschat.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.ivschat.model.primitives.TagValue.Type
    object Time extends Subtype[Instant]
    type Time = zio.aws.ivschat.model.primitives.Time.Type
    object UserID extends Subtype[String]
    type UserID = zio.aws.ivschat.model.primitives.UserID.Type
  }
  type ChatTokenAttributes = Map[String, String]
  type ChatTokenCapabilities = List[zio.aws.ivschat.model.ChatTokenCapability]
  type EventAttributes = Map[String, String]
  type LoggingConfigurationIdentifierList = List[LoggingConfigurationIdentifier]
  type LoggingConfigurationList =
    List[zio.aws.ivschat.model.LoggingConfigurationSummary]
  type RoomList = List[zio.aws.ivschat.model.RoomSummary]
  type TagKeyList = List[TagKey]
  type Tags = Map[TagKey, TagValue]
}
