package zio.aws.ivschat.model
import zio.aws.ivschat.model.primitives.{
  LoggingConfigurationIdentifier,
  RoomMaxMessageRatePerSecond,
  RoomMaxMessageLength,
  RoomIdentifier,
  RoomName
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class UpdateRoomRequest(
    identifier: RoomIdentifier,
    loggingConfigurationIdentifiers: Optional[
      Iterable[LoggingConfigurationIdentifier]
    ] = Optional.Absent,
    maximumMessageLength: Optional[RoomMaxMessageLength] = Optional.Absent,
    maximumMessageRatePerSecond: Optional[RoomMaxMessageRatePerSecond] =
      Optional.Absent,
    messageReviewHandler: Optional[zio.aws.ivschat.model.MessageReviewHandler] =
      Optional.Absent,
    name: Optional[RoomName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivschat.model.UpdateRoomRequest = {
    import UpdateRoomRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivschat.model.UpdateRoomRequest
      .builder()
      .identifier(RoomIdentifier.unwrap(identifier): java.lang.String)
      .optionallyWith(
        loggingConfigurationIdentifiers.map(value =>
          value.map { item =>
            LoggingConfigurationIdentifier.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.loggingConfigurationIdentifiers)
      .optionallyWith(
        maximumMessageLength.map(value =>
          RoomMaxMessageLength.unwrap(value): Integer
        )
      )(_.maximumMessageLength)
      .optionallyWith(
        maximumMessageRatePerSecond.map(value =>
          RoomMaxMessageRatePerSecond.unwrap(value): Integer
        )
      )(_.maximumMessageRatePerSecond)
      .optionallyWith(messageReviewHandler.map(value => value.buildAwsValue()))(
        _.messageReviewHandler
      )
      .optionallyWith(
        name.map(value => RoomName.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly: zio.aws.ivschat.model.UpdateRoomRequest.ReadOnly =
    zio.aws.ivschat.model.UpdateRoomRequest.wrap(buildAwsValue())
}
object UpdateRoomRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivschat.model.UpdateRoomRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivschat.model.UpdateRoomRequest =
      zio.aws.ivschat.model.UpdateRoomRequest(
        identifier,
        loggingConfigurationIdentifiers.map(value => value),
        maximumMessageLength.map(value => value),
        maximumMessageRatePerSecond.map(value => value),
        messageReviewHandler.map(value => value.asEditable),
        name.map(value => value)
      )
    def identifier: RoomIdentifier
    def loggingConfigurationIdentifiers
        : Optional[List[LoggingConfigurationIdentifier]]
    def maximumMessageLength: Optional[RoomMaxMessageLength]
    def maximumMessageRatePerSecond: Optional[RoomMaxMessageRatePerSecond]
    def messageReviewHandler
        : Optional[zio.aws.ivschat.model.MessageReviewHandler.ReadOnly]
    def name: Optional[RoomName]
    def getIdentifier: ZIO[Any, Nothing, RoomIdentifier] =
      ZIO.succeed(identifier)
    def getLoggingConfigurationIdentifiers
        : ZIO[Any, AwsError, List[LoggingConfigurationIdentifier]] =
      AwsError.unwrapOptionField(
        "loggingConfigurationIdentifiers",
        loggingConfigurationIdentifiers
      )
    def getMaximumMessageLength: ZIO[Any, AwsError, RoomMaxMessageLength] =
      AwsError.unwrapOptionField("maximumMessageLength", maximumMessageLength)
    def getMaximumMessageRatePerSecond
        : ZIO[Any, AwsError, RoomMaxMessageRatePerSecond] =
      AwsError.unwrapOptionField(
        "maximumMessageRatePerSecond",
        maximumMessageRatePerSecond
      )
    def getMessageReviewHandler: ZIO[
      Any,
      AwsError,
      zio.aws.ivschat.model.MessageReviewHandler.ReadOnly
    ] = AwsError.unwrapOptionField("messageReviewHandler", messageReviewHandler)
    def getName: ZIO[Any, AwsError, RoomName] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivschat.model.UpdateRoomRequest
  ) extends zio.aws.ivschat.model.UpdateRoomRequest.ReadOnly {
    override val identifier: RoomIdentifier =
      zio.aws.ivschat.model.primitives.RoomIdentifier(impl.identifier())
    override val loggingConfigurationIdentifiers
        : Optional[List[LoggingConfigurationIdentifier]] = zio.aws.core.internal
      .optionalFromNullable(impl.loggingConfigurationIdentifiers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ivschat.model.primitives.LoggingConfigurationIdentifier(item)
        }.toList
      )
    override val maximumMessageLength: Optional[RoomMaxMessageLength] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maximumMessageLength())
        .map(value =>
          zio.aws.ivschat.model.primitives.RoomMaxMessageLength(value)
        )
    override val maximumMessageRatePerSecond
        : Optional[RoomMaxMessageRatePerSecond] = zio.aws.core.internal
      .optionalFromNullable(impl.maximumMessageRatePerSecond())
      .map(value =>
        zio.aws.ivschat.model.primitives.RoomMaxMessageRatePerSecond(value)
      )
    override val messageReviewHandler
        : Optional[zio.aws.ivschat.model.MessageReviewHandler.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.messageReviewHandler())
        .map(value => zio.aws.ivschat.model.MessageReviewHandler.wrap(value))
    override val name: Optional[RoomName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.ivschat.model.primitives.RoomName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivschat.model.UpdateRoomRequest
  ): zio.aws.ivschat.model.UpdateRoomRequest.ReadOnly = new Wrapper(impl)
}
