package zio.aws.ivschat.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.ivschat.model.primitives.{
  LoggingConfigurationName,
  LoggingConfigurationIdentifier
}
import scala.jdk.CollectionConverters.*
final case class UpdateLoggingConfigurationRequest(
    destinationConfiguration: Optional[
      zio.aws.ivschat.model.DestinationConfiguration
    ] = Optional.Absent,
    identifier: LoggingConfigurationIdentifier,
    name: Optional[LoggingConfigurationName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivschat.model.UpdateLoggingConfigurationRequest = {
    import UpdateLoggingConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivschat.model.UpdateLoggingConfigurationRequest
      .builder()
      .optionallyWith(
        destinationConfiguration.map(value => value.buildAwsValue())
      )(_.destinationConfiguration)
      .identifier(
        LoggingConfigurationIdentifier.unwrap(identifier): java.lang.String
      )
      .optionallyWith(
        name.map(value =>
          LoggingConfigurationName.unwrap(value): java.lang.String
        )
      )(_.name)
      .build()
  }
  def asReadOnly
      : zio.aws.ivschat.model.UpdateLoggingConfigurationRequest.ReadOnly =
    zio.aws.ivschat.model.UpdateLoggingConfigurationRequest
      .wrap(buildAwsValue())
}
object UpdateLoggingConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivschat.model.UpdateLoggingConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivschat.model.UpdateLoggingConfigurationRequest =
      zio.aws.ivschat.model.UpdateLoggingConfigurationRequest(
        destinationConfiguration.map(value => value.asEditable),
        identifier,
        name.map(value => value)
      )
    def destinationConfiguration
        : Optional[zio.aws.ivschat.model.DestinationConfiguration.ReadOnly]
    def identifier: LoggingConfigurationIdentifier
    def name: Optional[LoggingConfigurationName]
    def getDestinationConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.ivschat.model.DestinationConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "destinationConfiguration",
      destinationConfiguration
    )
    def getIdentifier: ZIO[Any, Nothing, LoggingConfigurationIdentifier] =
      ZIO.succeed(identifier)
    def getName: ZIO[Any, AwsError, LoggingConfigurationName] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivschat.model.UpdateLoggingConfigurationRequest
  ) extends zio.aws.ivschat.model.UpdateLoggingConfigurationRequest.ReadOnly {
    override val destinationConfiguration
        : Optional[zio.aws.ivschat.model.DestinationConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationConfiguration())
        .map(value =>
          zio.aws.ivschat.model.DestinationConfiguration.wrap(value)
        )
    override val identifier: LoggingConfigurationIdentifier =
      zio.aws.ivschat.model.primitives
        .LoggingConfigurationIdentifier(impl.identifier())
    override val name: Optional[LoggingConfigurationName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value =>
          zio.aws.ivschat.model.primitives.LoggingConfigurationName(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivschat.model.UpdateLoggingConfigurationRequest
  ): zio.aws.ivschat.model.UpdateLoggingConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
