package zio.aws.ivschat.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.ivschat.model.primitives.ID
import scala.jdk.CollectionConverters.*
final case class SendEventResponse(id: Optional[ID] = Optional.Absent) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivschat.model.SendEventResponse = {
    import SendEventResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivschat.model.SendEventResponse
      .builder()
      .optionallyWith(id.map(value => ID.unwrap(value): java.lang.String))(_.id)
      .build()
  }
  def asReadOnly: zio.aws.ivschat.model.SendEventResponse.ReadOnly =
    zio.aws.ivschat.model.SendEventResponse.wrap(buildAwsValue())
}
object SendEventResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivschat.model.SendEventResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivschat.model.SendEventResponse =
      zio.aws.ivschat.model.SendEventResponse(id.map(value => value))
    def id: Optional[ID]
    def getId: ZIO[Any, AwsError, ID] = AwsError.unwrapOptionField("id", id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivschat.model.SendEventResponse
  ) extends zio.aws.ivschat.model.SendEventResponse.ReadOnly {
    override val id: Optional[ID] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.ivschat.model.primitives.ID(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivschat.model.SendEventResponse
  ): zio.aws.ivschat.model.SendEventResponse.ReadOnly = new Wrapper(impl)
}
