package zio.aws.ivschat.model
import scala.jdk.CollectionConverters.*
sealed trait LoggingConfigurationState {
  def unwrap
      : software.amazon.awssdk.services.ivschat.model.LoggingConfigurationState
}
object LoggingConfigurationState {
  def wrap(
      value: software.amazon.awssdk.services.ivschat.model.LoggingConfigurationState
  ): zio.aws.ivschat.model.LoggingConfigurationState = value match {
    case software.amazon.awssdk.services.ivschat.model.LoggingConfigurationState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ivschat.model.LoggingConfigurationState.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.ivschat.model.LoggingConfigurationState.CREATE_FAILED =>
      val r = CREATE_FAILED
      r
    case software.amazon.awssdk.services.ivschat.model.LoggingConfigurationState.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.ivschat.model.LoggingConfigurationState.DELETE_FAILED =>
      val r = DELETE_FAILED
      r
    case software.amazon.awssdk.services.ivschat.model.LoggingConfigurationState.UPDATING =>
      val r = UPDATING
      r
    case software.amazon.awssdk.services.ivschat.model.LoggingConfigurationState.UPDATE_FAILED =>
      val r = UPDATE_FAILED
      r
    case software.amazon.awssdk.services.ivschat.model.LoggingConfigurationState.ACTIVE =>
      val r = ACTIVE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ivschat.model.LoggingConfigurationState {
    override def unwrap
        : software.amazon.awssdk.services.ivschat.model.LoggingConfigurationState =
      software.amazon.awssdk.services.ivschat.model.LoggingConfigurationState.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATING extends zio.aws.ivschat.model.LoggingConfigurationState {
    override def unwrap
        : software.amazon.awssdk.services.ivschat.model.LoggingConfigurationState =
      software.amazon.awssdk.services.ivschat.model.LoggingConfigurationState.CREATING
  }
  case object CREATE_FAILED
      extends zio.aws.ivschat.model.LoggingConfigurationState {
    override def unwrap
        : software.amazon.awssdk.services.ivschat.model.LoggingConfigurationState =
      software.amazon.awssdk.services.ivschat.model.LoggingConfigurationState.CREATE_FAILED
  }
  case object DELETING extends zio.aws.ivschat.model.LoggingConfigurationState {
    override def unwrap
        : software.amazon.awssdk.services.ivschat.model.LoggingConfigurationState =
      software.amazon.awssdk.services.ivschat.model.LoggingConfigurationState.DELETING
  }
  case object DELETE_FAILED
      extends zio.aws.ivschat.model.LoggingConfigurationState {
    override def unwrap
        : software.amazon.awssdk.services.ivschat.model.LoggingConfigurationState =
      software.amazon.awssdk.services.ivschat.model.LoggingConfigurationState.DELETE_FAILED
  }
  case object UPDATING extends zio.aws.ivschat.model.LoggingConfigurationState {
    override def unwrap
        : software.amazon.awssdk.services.ivschat.model.LoggingConfigurationState =
      software.amazon.awssdk.services.ivschat.model.LoggingConfigurationState.UPDATING
  }
  case object UPDATE_FAILED
      extends zio.aws.ivschat.model.LoggingConfigurationState {
    override def unwrap
        : software.amazon.awssdk.services.ivschat.model.LoggingConfigurationState =
      software.amazon.awssdk.services.ivschat.model.LoggingConfigurationState.UPDATE_FAILED
  }
  case object ACTIVE extends zio.aws.ivschat.model.LoggingConfigurationState {
    override def unwrap
        : software.amazon.awssdk.services.ivschat.model.LoggingConfigurationState =
      software.amazon.awssdk.services.ivschat.model.LoggingConfigurationState.ACTIVE
  }
}
