package zio.aws.ivschat.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.ivschat.model.primitives.{TagValue, TagKey}
import scala.jdk.CollectionConverters.*
final case class ListTagsForResourceResponse(tags: Map[TagKey, TagValue]) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivschat.model.ListTagsForResourceResponse = {
    import ListTagsForResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivschat.model.ListTagsForResourceResponse
      .builder()
      .tags(
        tags
          .map({ case (key, value) =>
            (TagKey.unwrap(key): java.lang.String) -> (TagValue
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.ivschat.model.ListTagsForResourceResponse.ReadOnly =
    zio.aws.ivschat.model.ListTagsForResourceResponse.wrap(buildAwsValue())
}
object ListTagsForResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivschat.model.ListTagsForResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivschat.model.ListTagsForResourceResponse =
      zio.aws.ivschat.model.ListTagsForResourceResponse(tags)
    def tags: Map[TagKey, TagValue]
    def getTags: ZIO[Any, Nothing, Map[TagKey, TagValue]] = ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivschat.model.ListTagsForResourceResponse
  ) extends zio.aws.ivschat.model.ListTagsForResourceResponse.ReadOnly {
    override val tags: Map[TagKey, TagValue] = impl
      .tags()
      .asScala
      .map({ case (key, value) =>
        zio.aws.ivschat.model.primitives
          .TagKey(key) -> zio.aws.ivschat.model.primitives.TagValue(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivschat.model.ListTagsForResourceResponse
  ): zio.aws.ivschat.model.ListTagsForResourceResponse.ReadOnly = new Wrapper(
    impl
  )
}
