package zio.aws.ivschat.model
import zio.aws.ivschat.model.primitives.{
  LoggingConfigurationIdentifier,
  LambdaArn,
  PaginationToken,
  RoomName,
  MaxRoomResults
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListRoomsRequest(
    loggingConfigurationIdentifier: Optional[LoggingConfigurationIdentifier] =
      Optional.Absent,
    maxResults: Optional[MaxRoomResults] = Optional.Absent,
    messageReviewHandlerUri: Optional[LambdaArn] = Optional.Absent,
    name: Optional[RoomName] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivschat.model.ListRoomsRequest = {
    import ListRoomsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivschat.model.ListRoomsRequest
      .builder()
      .optionallyWith(
        loggingConfigurationIdentifier.map(value =>
          LoggingConfigurationIdentifier.unwrap(value): java.lang.String
        )
      )(_.loggingConfigurationIdentifier)
      .optionallyWith(
        maxResults.map(value => MaxRoomResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        messageReviewHandlerUri.map(value =>
          LambdaArn.unwrap(value): java.lang.String
        )
      )(_.messageReviewHandlerUri)
      .optionallyWith(
        name.map(value => RoomName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ivschat.model.ListRoomsRequest.ReadOnly =
    zio.aws.ivschat.model.ListRoomsRequest.wrap(buildAwsValue())
}
object ListRoomsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivschat.model.ListRoomsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivschat.model.ListRoomsRequest =
      zio.aws.ivschat.model.ListRoomsRequest(
        loggingConfigurationIdentifier.map(value => value),
        maxResults.map(value => value),
        messageReviewHandlerUri.map(value => value),
        name.map(value => value),
        nextToken.map(value => value)
      )
    def loggingConfigurationIdentifier: Optional[LoggingConfigurationIdentifier]
    def maxResults: Optional[MaxRoomResults]
    def messageReviewHandlerUri: Optional[LambdaArn]
    def name: Optional[RoomName]
    def nextToken: Optional[PaginationToken]
    def getLoggingConfigurationIdentifier
        : ZIO[Any, AwsError, LoggingConfigurationIdentifier] =
      AwsError.unwrapOptionField(
        "loggingConfigurationIdentifier",
        loggingConfigurationIdentifier
      )
    def getMaxResults: ZIO[Any, AwsError, MaxRoomResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getMessageReviewHandlerUri: ZIO[Any, AwsError, LambdaArn] = AwsError
      .unwrapOptionField("messageReviewHandlerUri", messageReviewHandlerUri)
    def getName: ZIO[Any, AwsError, RoomName] =
      AwsError.unwrapOptionField("name", name)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivschat.model.ListRoomsRequest
  ) extends zio.aws.ivschat.model.ListRoomsRequest.ReadOnly {
    override val loggingConfigurationIdentifier
        : Optional[LoggingConfigurationIdentifier] = zio.aws.core.internal
      .optionalFromNullable(impl.loggingConfigurationIdentifier())
      .map(value =>
        zio.aws.ivschat.model.primitives.LoggingConfigurationIdentifier(value)
      )
    override val maxResults: Optional[MaxRoomResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.ivschat.model.primitives.MaxRoomResults(value))
    override val messageReviewHandlerUri: Optional[LambdaArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.messageReviewHandlerUri())
        .map(value => zio.aws.ivschat.model.primitives.LambdaArn(value))
    override val name: Optional[RoomName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.ivschat.model.primitives.RoomName(value))
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ivschat.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivschat.model.ListRoomsRequest
  ): zio.aws.ivschat.model.ListRoomsRequest.ReadOnly = new Wrapper(impl)
}
