package zio.aws.ivschat.model
import zio.aws.ivschat.model.primitives.{
  PaginationToken,
  MaxLoggingConfigurationResults
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListLoggingConfigurationsRequest(
    maxResults: Optional[MaxLoggingConfigurationResults] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivschat.model.ListLoggingConfigurationsRequest = {
    import ListLoggingConfigurationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivschat.model.ListLoggingConfigurationsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value =>
          MaxLoggingConfigurationResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ivschat.model.ListLoggingConfigurationsRequest.ReadOnly =
    zio.aws.ivschat.model.ListLoggingConfigurationsRequest.wrap(buildAwsValue())
}
object ListLoggingConfigurationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivschat.model.ListLoggingConfigurationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivschat.model.ListLoggingConfigurationsRequest =
      zio.aws.ivschat.model.ListLoggingConfigurationsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Optional[MaxLoggingConfigurationResults]
    def nextToken: Optional[PaginationToken]
    def getMaxResults: ZIO[Any, AwsError, MaxLoggingConfigurationResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivschat.model.ListLoggingConfigurationsRequest
  ) extends zio.aws.ivschat.model.ListLoggingConfigurationsRequest.ReadOnly {
    override val maxResults: Optional[MaxLoggingConfigurationResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.ivschat.model.primitives.MaxLoggingConfigurationResults(value)
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ivschat.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivschat.model.ListLoggingConfigurationsRequest
  ): zio.aws.ivschat.model.ListLoggingConfigurationsRequest.ReadOnly =
    new Wrapper(impl)
}
