package zio.aws.ivschat.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.ivschat.model.primitives.LoggingConfigurationIdentifier
import scala.jdk.CollectionConverters.*
final case class GetLoggingConfigurationRequest(
    identifier: LoggingConfigurationIdentifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivschat.model.GetLoggingConfigurationRequest = {
    import GetLoggingConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivschat.model.GetLoggingConfigurationRequest
      .builder()
      .identifier(
        LoggingConfigurationIdentifier.unwrap(identifier): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ivschat.model.GetLoggingConfigurationRequest.ReadOnly =
    zio.aws.ivschat.model.GetLoggingConfigurationRequest.wrap(buildAwsValue())
}
object GetLoggingConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivschat.model.GetLoggingConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivschat.model.GetLoggingConfigurationRequest =
      zio.aws.ivschat.model.GetLoggingConfigurationRequest(identifier)
    def identifier: LoggingConfigurationIdentifier
    def getIdentifier: ZIO[Any, Nothing, LoggingConfigurationIdentifier] =
      ZIO.succeed(identifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivschat.model.GetLoggingConfigurationRequest
  ) extends zio.aws.ivschat.model.GetLoggingConfigurationRequest.ReadOnly {
    override val identifier: LoggingConfigurationIdentifier =
      zio.aws.ivschat.model.primitives
        .LoggingConfigurationIdentifier(impl.identifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivschat.model.GetLoggingConfigurationRequest
  ): zio.aws.ivschat.model.GetLoggingConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
