package zio.aws.ivschat.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.ivschat.model.primitives.RoomIdentifier
import scala.jdk.CollectionConverters.*
final case class DeleteRoomRequest(identifier: RoomIdentifier) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivschat.model.DeleteRoomRequest = {
    import DeleteRoomRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivschat.model.DeleteRoomRequest
      .builder()
      .identifier(RoomIdentifier.unwrap(identifier): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ivschat.model.DeleteRoomRequest.ReadOnly =
    zio.aws.ivschat.model.DeleteRoomRequest.wrap(buildAwsValue())
}
object DeleteRoomRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivschat.model.DeleteRoomRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivschat.model.DeleteRoomRequest =
      zio.aws.ivschat.model.DeleteRoomRequest(identifier)
    def identifier: RoomIdentifier
    def getIdentifier: ZIO[Any, Nothing, RoomIdentifier] =
      ZIO.succeed(identifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivschat.model.DeleteRoomRequest
  ) extends zio.aws.ivschat.model.DeleteRoomRequest.ReadOnly {
    override val identifier: RoomIdentifier =
      zio.aws.ivschat.model.primitives.RoomIdentifier(impl.identifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivschat.model.DeleteRoomRequest
  ): zio.aws.ivschat.model.DeleteRoomRequest.ReadOnly = new Wrapper(impl)
}
