package zio.aws.ivschat.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.ivschat.model.primitives.{RoomIdentifier, Reason, MessageID}
import scala.jdk.CollectionConverters.*
final case class DeleteMessageRequest(
    id: MessageID,
    reason: Optional[Reason] = Optional.Absent,
    roomIdentifier: RoomIdentifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivschat.model.DeleteMessageRequest = {
    import DeleteMessageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivschat.model.DeleteMessageRequest
      .builder()
      .id(MessageID.unwrap(id): java.lang.String)
      .optionallyWith(
        reason.map(value => Reason.unwrap(value): java.lang.String)
      )(_.reason)
      .roomIdentifier(RoomIdentifier.unwrap(roomIdentifier): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ivschat.model.DeleteMessageRequest.ReadOnly =
    zio.aws.ivschat.model.DeleteMessageRequest.wrap(buildAwsValue())
}
object DeleteMessageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivschat.model.DeleteMessageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivschat.model.DeleteMessageRequest =
      zio.aws.ivschat.model
        .DeleteMessageRequest(id, reason.map(value => value), roomIdentifier)
    def id: MessageID
    def reason: Optional[Reason]
    def roomIdentifier: RoomIdentifier
    def getId: ZIO[Any, Nothing, MessageID] = ZIO.succeed(id)
    def getReason: ZIO[Any, AwsError, Reason] =
      AwsError.unwrapOptionField("reason", reason)
    def getRoomIdentifier: ZIO[Any, Nothing, RoomIdentifier] =
      ZIO.succeed(roomIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivschat.model.DeleteMessageRequest
  ) extends zio.aws.ivschat.model.DeleteMessageRequest.ReadOnly {
    override val id: MessageID =
      zio.aws.ivschat.model.primitives.MessageID(impl.id())
    override val reason: Optional[Reason] = zio.aws.core.internal
      .optionalFromNullable(impl.reason())
      .map(value => zio.aws.ivschat.model.primitives.Reason(value))
    override val roomIdentifier: RoomIdentifier =
      zio.aws.ivschat.model.primitives.RoomIdentifier(impl.roomIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivschat.model.DeleteMessageRequest
  ): zio.aws.ivschat.model.DeleteMessageRequest.ReadOnly = new Wrapper(impl)
}
