package zio.aws.ivschat.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.ivschat.model.primitives.LoggingConfigurationIdentifier
import scala.jdk.CollectionConverters.*
final case class DeleteLoggingConfigurationRequest(
    identifier: LoggingConfigurationIdentifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivschat.model.DeleteLoggingConfigurationRequest = {
    import DeleteLoggingConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivschat.model.DeleteLoggingConfigurationRequest
      .builder()
      .identifier(
        LoggingConfigurationIdentifier.unwrap(identifier): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ivschat.model.DeleteLoggingConfigurationRequest.ReadOnly =
    zio.aws.ivschat.model.DeleteLoggingConfigurationRequest
      .wrap(buildAwsValue())
}
object DeleteLoggingConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivschat.model.DeleteLoggingConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivschat.model.DeleteLoggingConfigurationRequest =
      zio.aws.ivschat.model.DeleteLoggingConfigurationRequest(identifier)
    def identifier: LoggingConfigurationIdentifier
    def getIdentifier: ZIO[Any, Nothing, LoggingConfigurationIdentifier] =
      ZIO.succeed(identifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivschat.model.DeleteLoggingConfigurationRequest
  ) extends zio.aws.ivschat.model.DeleteLoggingConfigurationRequest.ReadOnly {
    override val identifier: LoggingConfigurationIdentifier =
      zio.aws.ivschat.model.primitives
        .LoggingConfigurationIdentifier(impl.identifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivschat.model.DeleteLoggingConfigurationRequest
  ): zio.aws.ivschat.model.DeleteLoggingConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
