package zio.aws.ivschat.model
import zio.aws.ivschat.model.primitives.{
  LoggingConfigurationIdentifier,
  RoomMaxMessageRatePerSecond,
  TagValue,
  RoomMaxMessageLength,
  RoomName,
  TagKey
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class CreateRoomRequest(
    loggingConfigurationIdentifiers: Optional[
      Iterable[LoggingConfigurationIdentifier]
    ] = Optional.Absent,
    maximumMessageLength: Optional[RoomMaxMessageLength] = Optional.Absent,
    maximumMessageRatePerSecond: Optional[RoomMaxMessageRatePerSecond] =
      Optional.Absent,
    messageReviewHandler: Optional[zio.aws.ivschat.model.MessageReviewHandler] =
      Optional.Absent,
    name: Optional[RoomName] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivschat.model.CreateRoomRequest = {
    import CreateRoomRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivschat.model.CreateRoomRequest
      .builder()
      .optionallyWith(
        loggingConfigurationIdentifiers.map(value =>
          value.map { item =>
            LoggingConfigurationIdentifier.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.loggingConfigurationIdentifiers)
      .optionallyWith(
        maximumMessageLength.map(value =>
          RoomMaxMessageLength.unwrap(value): Integer
        )
      )(_.maximumMessageLength)
      .optionallyWith(
        maximumMessageRatePerSecond.map(value =>
          RoomMaxMessageRatePerSecond.unwrap(value): Integer
        )
      )(_.maximumMessageRatePerSecond)
      .optionallyWith(messageReviewHandler.map(value => value.buildAwsValue()))(
        _.messageReviewHandler
      )
      .optionallyWith(
        name.map(value => RoomName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ivschat.model.CreateRoomRequest.ReadOnly =
    zio.aws.ivschat.model.CreateRoomRequest.wrap(buildAwsValue())
}
object CreateRoomRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivschat.model.CreateRoomRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivschat.model.CreateRoomRequest =
      zio.aws.ivschat.model.CreateRoomRequest(
        loggingConfigurationIdentifiers.map(value => value),
        maximumMessageLength.map(value => value),
        maximumMessageRatePerSecond.map(value => value),
        messageReviewHandler.map(value => value.asEditable),
        name.map(value => value),
        tags.map(value => value)
      )
    def loggingConfigurationIdentifiers
        : Optional[List[LoggingConfigurationIdentifier]]
    def maximumMessageLength: Optional[RoomMaxMessageLength]
    def maximumMessageRatePerSecond: Optional[RoomMaxMessageRatePerSecond]
    def messageReviewHandler
        : Optional[zio.aws.ivschat.model.MessageReviewHandler.ReadOnly]
    def name: Optional[RoomName]
    def tags: Optional[Map[TagKey, TagValue]]
    def getLoggingConfigurationIdentifiers
        : ZIO[Any, AwsError, List[LoggingConfigurationIdentifier]] =
      AwsError.unwrapOptionField(
        "loggingConfigurationIdentifiers",
        loggingConfigurationIdentifiers
      )
    def getMaximumMessageLength: ZIO[Any, AwsError, RoomMaxMessageLength] =
      AwsError.unwrapOptionField("maximumMessageLength", maximumMessageLength)
    def getMaximumMessageRatePerSecond
        : ZIO[Any, AwsError, RoomMaxMessageRatePerSecond] =
      AwsError.unwrapOptionField(
        "maximumMessageRatePerSecond",
        maximumMessageRatePerSecond
      )
    def getMessageReviewHandler: ZIO[
      Any,
      AwsError,
      zio.aws.ivschat.model.MessageReviewHandler.ReadOnly
    ] = AwsError.unwrapOptionField("messageReviewHandler", messageReviewHandler)
    def getName: ZIO[Any, AwsError, RoomName] =
      AwsError.unwrapOptionField("name", name)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivschat.model.CreateRoomRequest
  ) extends zio.aws.ivschat.model.CreateRoomRequest.ReadOnly {
    override val loggingConfigurationIdentifiers
        : Optional[List[LoggingConfigurationIdentifier]] = zio.aws.core.internal
      .optionalFromNullable(impl.loggingConfigurationIdentifiers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ivschat.model.primitives.LoggingConfigurationIdentifier(item)
        }.toList
      )
    override val maximumMessageLength: Optional[RoomMaxMessageLength] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maximumMessageLength())
        .map(value =>
          zio.aws.ivschat.model.primitives.RoomMaxMessageLength(value)
        )
    override val maximumMessageRatePerSecond
        : Optional[RoomMaxMessageRatePerSecond] = zio.aws.core.internal
      .optionalFromNullable(impl.maximumMessageRatePerSecond())
      .map(value =>
        zio.aws.ivschat.model.primitives.RoomMaxMessageRatePerSecond(value)
      )
    override val messageReviewHandler
        : Optional[zio.aws.ivschat.model.MessageReviewHandler.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.messageReviewHandler())
        .map(value => zio.aws.ivschat.model.MessageReviewHandler.wrap(value))
    override val name: Optional[RoomName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.ivschat.model.primitives.RoomName(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.ivschat.model.primitives
              .TagKey(key) -> zio.aws.ivschat.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivschat.model.CreateRoomRequest
  ): zio.aws.ivschat.model.CreateRoomRequest.ReadOnly = new Wrapper(impl)
}
