package zio.aws.ivschat.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.ivschat.model.primitives.{
  TagValue,
  TagKey,
  LoggingConfigurationName
}
import scala.jdk.CollectionConverters.*
final case class CreateLoggingConfigurationRequest(
    destinationConfiguration: zio.aws.ivschat.model.DestinationConfiguration,
    name: Optional[LoggingConfigurationName] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivschat.model.CreateLoggingConfigurationRequest = {
    import CreateLoggingConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivschat.model.CreateLoggingConfigurationRequest
      .builder()
      .destinationConfiguration(destinationConfiguration.buildAwsValue())
      .optionallyWith(
        name.map(value =>
          LoggingConfigurationName.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.ivschat.model.CreateLoggingConfigurationRequest.ReadOnly =
    zio.aws.ivschat.model.CreateLoggingConfigurationRequest
      .wrap(buildAwsValue())
}
object CreateLoggingConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivschat.model.CreateLoggingConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivschat.model.CreateLoggingConfigurationRequest =
      zio.aws.ivschat.model.CreateLoggingConfigurationRequest(
        destinationConfiguration.asEditable,
        name.map(value => value),
        tags.map(value => value)
      )
    def destinationConfiguration
        : zio.aws.ivschat.model.DestinationConfiguration.ReadOnly
    def name: Optional[LoggingConfigurationName]
    def tags: Optional[Map[TagKey, TagValue]]
    def getDestinationConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.ivschat.model.DestinationConfiguration.ReadOnly
    ] = ZIO.succeed(destinationConfiguration)
    def getName: ZIO[Any, AwsError, LoggingConfigurationName] =
      AwsError.unwrapOptionField("name", name)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivschat.model.CreateLoggingConfigurationRequest
  ) extends zio.aws.ivschat.model.CreateLoggingConfigurationRequest.ReadOnly {
    override val destinationConfiguration
        : zio.aws.ivschat.model.DestinationConfiguration.ReadOnly =
      zio.aws.ivschat.model.DestinationConfiguration
        .wrap(impl.destinationConfiguration())
    override val name: Optional[LoggingConfigurationName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value =>
          zio.aws.ivschat.model.primitives.LoggingConfigurationName(value)
        )
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.ivschat.model.primitives
              .TagKey(key) -> zio.aws.ivschat.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivschat.model.CreateLoggingConfigurationRequest
  ): zio.aws.ivschat.model.CreateLoggingConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
