package zio.aws.ivschat.model
import zio.aws.ivschat.model.primitives.{ChatToken, Time}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class CreateChatTokenResponse(
    sessionExpirationTime: Optional[Time] = Optional.Absent,
    token: Optional[ChatToken] = Optional.Absent,
    tokenExpirationTime: Optional[Time] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivschat.model.CreateChatTokenResponse = {
    import CreateChatTokenResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivschat.model.CreateChatTokenResponse
      .builder()
      .optionallyWith(
        sessionExpirationTime.map(value => Time.unwrap(value): Instant)
      )(_.sessionExpirationTime)
      .optionallyWith(
        token.map(value => ChatToken.unwrap(value): java.lang.String)
      )(_.token)
      .optionallyWith(
        tokenExpirationTime.map(value => Time.unwrap(value): Instant)
      )(_.tokenExpirationTime)
      .build()
  }
  def asReadOnly: zio.aws.ivschat.model.CreateChatTokenResponse.ReadOnly =
    zio.aws.ivschat.model.CreateChatTokenResponse.wrap(buildAwsValue())
}
object CreateChatTokenResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivschat.model.CreateChatTokenResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivschat.model.CreateChatTokenResponse =
      zio.aws.ivschat.model.CreateChatTokenResponse(
        sessionExpirationTime.map(value => value),
        token.map(value => value),
        tokenExpirationTime.map(value => value)
      )
    def sessionExpirationTime: Optional[Time]
    def token: Optional[ChatToken]
    def tokenExpirationTime: Optional[Time]
    def getSessionExpirationTime: ZIO[Any, AwsError, Time] =
      AwsError.unwrapOptionField("sessionExpirationTime", sessionExpirationTime)
    def getToken: ZIO[Any, AwsError, ChatToken] =
      AwsError.unwrapOptionField("token", token)
    def getTokenExpirationTime: ZIO[Any, AwsError, Time] =
      AwsError.unwrapOptionField("tokenExpirationTime", tokenExpirationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivschat.model.CreateChatTokenResponse
  ) extends zio.aws.ivschat.model.CreateChatTokenResponse.ReadOnly {
    override val sessionExpirationTime: Optional[Time] = zio.aws.core.internal
      .optionalFromNullable(impl.sessionExpirationTime())
      .map(value => zio.aws.ivschat.model.primitives.Time(value))
    override val token: Optional[ChatToken] = zio.aws.core.internal
      .optionalFromNullable(impl.token())
      .map(value => zio.aws.ivschat.model.primitives.ChatToken(value))
    override val tokenExpirationTime: Optional[Time] = zio.aws.core.internal
      .optionalFromNullable(impl.tokenExpirationTime())
      .map(value => zio.aws.ivschat.model.primitives.Time(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivschat.model.CreateChatTokenResponse
  ): zio.aws.ivschat.model.CreateChatTokenResponse.ReadOnly = new Wrapper(impl)
}
