package zio.aws.ivschat
import zio.aws.ivschat.model.DisconnectUserResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import software.amazon.awssdk.services.ivschat.IvschatAsyncClient
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.ivschat.model.{
  GetLoggingConfigurationRequest,
  SendEventRequest,
  ListTagsForResourceRequest,
  ListLoggingConfigurationsRequest,
  CreateLoggingConfigurationRequest,
  DeleteRoomRequest,
  CreateChatTokenRequest,
  CreateRoomRequest,
  DeleteLoggingConfigurationRequest,
  UpdateLoggingConfigurationRequest,
  ListRoomsRequest,
  UntagResourceRequest,
  UpdateRoomRequest,
  GetRoomRequest,
  TagResourceRequest,
  DeleteMessageRequest,
  DisconnectUserRequest
}
object IvschatMock extends Mock[Ivschat] {
  object SendEvent
      extends Effect[
        SendEventRequest,
        AwsError,
        zio.aws.ivschat.model.SendEventResponse.ReadOnly
      ]
  object UpdateRoom
      extends Effect[
        UpdateRoomRequest,
        AwsError,
        zio.aws.ivschat.model.UpdateRoomResponse.ReadOnly
      ]
  object DeleteMessage
      extends Effect[
        DeleteMessageRequest,
        AwsError,
        zio.aws.ivschat.model.DeleteMessageResponse.ReadOnly
      ]
  object CreateChatToken
      extends Effect[
        CreateChatTokenRequest,
        AwsError,
        zio.aws.ivschat.model.CreateChatTokenResponse.ReadOnly
      ]
  object DisconnectUser
      extends Effect[DisconnectUserRequest, AwsError, ReadOnly]
  object CreateLoggingConfiguration
      extends Effect[
        CreateLoggingConfigurationRequest,
        AwsError,
        zio.aws.ivschat.model.CreateLoggingConfigurationResponse.ReadOnly
      ]
  object UpdateLoggingConfiguration
      extends Effect[
        UpdateLoggingConfigurationRequest,
        AwsError,
        zio.aws.ivschat.model.UpdateLoggingConfigurationResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.ivschat.model.UntagResourceResponse.ReadOnly
      ]
  object CreateRoom
      extends Effect[
        CreateRoomRequest,
        AwsError,
        zio.aws.ivschat.model.CreateRoomResponse.ReadOnly
      ]
  object DeleteRoom extends Effect[DeleteRoomRequest, AwsError, Unit]
  object GetLoggingConfiguration
      extends Effect[
        GetLoggingConfigurationRequest,
        AwsError,
        zio.aws.ivschat.model.GetLoggingConfigurationResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.ivschat.model.ListTagsForResourceResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.ivschat.model.TagResourceResponse.ReadOnly
      ]
  object ListLoggingConfigurations
      extends Effect[
        ListLoggingConfigurationsRequest,
        AwsError,
        zio.aws.ivschat.model.ListLoggingConfigurationsResponse.ReadOnly
      ]
  object GetRoom
      extends Effect[
        GetRoomRequest,
        AwsError,
        zio.aws.ivschat.model.GetRoomResponse.ReadOnly
      ]
  object DeleteLoggingConfiguration
      extends Effect[DeleteLoggingConfigurationRequest, AwsError, Unit]
  object ListRooms
      extends Effect[
        ListRoomsRequest,
        AwsError,
        zio.aws.ivschat.model.ListRoomsResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Ivschat] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, Ivschat] { rts =>
        zio.ZIO.succeed {
          new Ivschat {
            val api: IvschatAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): Ivschat = this
            def sendEvent(
                request: SendEventRequest
            ): IO[AwsError, zio.aws.ivschat.model.SendEventResponse.ReadOnly] =
              proxy(SendEvent, request)
            def updateRoom(
                request: UpdateRoomRequest
            ): IO[AwsError, zio.aws.ivschat.model.UpdateRoomResponse.ReadOnly] =
              proxy(UpdateRoom, request)
            def deleteMessage(request: DeleteMessageRequest): IO[
              AwsError,
              zio.aws.ivschat.model.DeleteMessageResponse.ReadOnly
            ] = proxy(DeleteMessage, request)
            def createChatToken(request: CreateChatTokenRequest): IO[
              AwsError,
              zio.aws.ivschat.model.CreateChatTokenResponse.ReadOnly
            ] = proxy(CreateChatToken, request)
            def disconnectUser(
                request: DisconnectUserRequest
            ): IO[AwsError, ReadOnly] = proxy(DisconnectUser, request)
            def createLoggingConfiguration(
                request: CreateLoggingConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.ivschat.model.CreateLoggingConfigurationResponse.ReadOnly
            ] = proxy(CreateLoggingConfiguration, request)
            def updateLoggingConfiguration(
                request: UpdateLoggingConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.ivschat.model.UpdateLoggingConfigurationResponse.ReadOnly
            ] = proxy(UpdateLoggingConfiguration, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.ivschat.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def createRoom(
                request: CreateRoomRequest
            ): IO[AwsError, zio.aws.ivschat.model.CreateRoomResponse.ReadOnly] =
              proxy(CreateRoom, request)
            def deleteRoom(request: DeleteRoomRequest): IO[AwsError, Unit] =
              proxy(DeleteRoom, request)
            def getLoggingConfiguration(
                request: GetLoggingConfigurationRequest
            ): IO[
              AwsError,
              zio.aws.ivschat.model.GetLoggingConfigurationResponse.ReadOnly
            ] = proxy(GetLoggingConfiguration, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.ivschat.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def tagResource(request: TagResourceRequest): IO[
              AwsError,
              zio.aws.ivschat.model.TagResourceResponse.ReadOnly
            ] = proxy(TagResource, request)
            def listLoggingConfigurations(
                request: ListLoggingConfigurationsRequest
            ): IO[
              AwsError,
              zio.aws.ivschat.model.ListLoggingConfigurationsResponse.ReadOnly
            ] = proxy(ListLoggingConfigurations, request)
            def getRoom(
                request: GetRoomRequest
            ): IO[AwsError, zio.aws.ivschat.model.GetRoomResponse.ReadOnly] =
              proxy(GetRoom, request)
            def deleteLoggingConfiguration(
                request: DeleteLoggingConfigurationRequest
            ): IO[AwsError, Unit] = proxy(DeleteLoggingConfiguration, request)
            def listRooms(
                request: ListRoomsRequest
            ): IO[AwsError, zio.aws.ivschat.model.ListRoomsResponse.ReadOnly] =
              proxy(ListRooms, request)
          }
        }
      }
    }
  }
}
