package zio.aws.ivschat
import zio.aws.ivschat.model.DisconnectUserResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import software.amazon.awssdk.services.ivschat.{
  IvschatAsyncClientBuilder,
  IvschatAsyncClient
}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import software.amazon.awssdk.services.ivschat.model.{
  GetLoggingConfigurationRequest,
  SendEventRequest,
  CreateLoggingConfigurationResponse,
  ListRoomsResponse,
  DeleteLoggingConfigurationResponse,
  SendEventResponse,
  ListTagsForResourceRequest,
  ListLoggingConfigurationsRequest,
  CreateLoggingConfigurationRequest,
  DeleteRoomRequest,
  ListTagsForResourceResponse,
  CreateChatTokenRequest,
  UpdateRoomResponse,
  CreateRoomRequest,
  UntagResourceResponse,
  ListLoggingConfigurationsResponse,
  GetRoomResponse,
  DeleteLoggingConfigurationRequest,
  UpdateLoggingConfigurationRequest,
  DeleteMessageResponse,
  ListRoomsRequest,
  UntagResourceRequest,
  GetLoggingConfigurationResponse,
  DisconnectUserResponse,
  UpdateRoomRequest,
  CreateChatTokenResponse,
  DeleteRoomResponse,
  TagResourceResponse,
  GetRoomRequest,
  TagResourceRequest,
  UpdateLoggingConfigurationResponse,
  DeleteMessageRequest,
  DisconnectUserRequest,
  CreateRoomResponse
}
import scala.jdk.CollectionConverters.*
trait Ivschat extends AspectSupport[Ivschat] {
  val api: IvschatAsyncClient
  def sendEvent(
      request: zio.aws.ivschat.model.SendEventRequest
  ): IO[AwsError, zio.aws.ivschat.model.SendEventResponse.ReadOnly]
  def updateRoom(
      request: zio.aws.ivschat.model.UpdateRoomRequest
  ): IO[AwsError, zio.aws.ivschat.model.UpdateRoomResponse.ReadOnly]
  def deleteMessage(
      request: zio.aws.ivschat.model.DeleteMessageRequest
  ): IO[AwsError, zio.aws.ivschat.model.DeleteMessageResponse.ReadOnly]
  def createChatToken(
      request: zio.aws.ivschat.model.CreateChatTokenRequest
  ): IO[AwsError, zio.aws.ivschat.model.CreateChatTokenResponse.ReadOnly]
  def disconnectUser(
      request: zio.aws.ivschat.model.DisconnectUserRequest
  ): IO[AwsError, ReadOnly]
  def createLoggingConfiguration(
      request: zio.aws.ivschat.model.CreateLoggingConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.ivschat.model.CreateLoggingConfigurationResponse.ReadOnly
  ]
  def updateLoggingConfiguration(
      request: zio.aws.ivschat.model.UpdateLoggingConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.ivschat.model.UpdateLoggingConfigurationResponse.ReadOnly
  ]
  def untagResource(
      request: zio.aws.ivschat.model.UntagResourceRequest
  ): IO[AwsError, zio.aws.ivschat.model.UntagResourceResponse.ReadOnly]
  def createRoom(
      request: zio.aws.ivschat.model.CreateRoomRequest
  ): IO[AwsError, zio.aws.ivschat.model.CreateRoomResponse.ReadOnly]
  def deleteRoom(
      request: zio.aws.ivschat.model.DeleteRoomRequest
  ): IO[AwsError, Unit]
  def getLoggingConfiguration(
      request: zio.aws.ivschat.model.GetLoggingConfigurationRequest
  ): IO[
    AwsError,
    zio.aws.ivschat.model.GetLoggingConfigurationResponse.ReadOnly
  ]
  def listTagsForResource(
      request: zio.aws.ivschat.model.ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.ivschat.model.ListTagsForResourceResponse.ReadOnly]
  def tagResource(
      request: zio.aws.ivschat.model.TagResourceRequest
  ): IO[AwsError, zio.aws.ivschat.model.TagResourceResponse.ReadOnly]
  def listLoggingConfigurations(
      request: zio.aws.ivschat.model.ListLoggingConfigurationsRequest
  ): IO[
    AwsError,
    zio.aws.ivschat.model.ListLoggingConfigurationsResponse.ReadOnly
  ]
  def getRoom(
      request: zio.aws.ivschat.model.GetRoomRequest
  ): IO[AwsError, zio.aws.ivschat.model.GetRoomResponse.ReadOnly]
  def deleteLoggingConfiguration(
      request: zio.aws.ivschat.model.DeleteLoggingConfigurationRequest
  ): IO[AwsError, Unit]
  def listRooms(
      request: zio.aws.ivschat.model.ListRoomsRequest
  ): IO[AwsError, zio.aws.ivschat.model.ListRoomsResponse.ReadOnly]
}
object Ivschat {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Ivschat] = customized(
    identity
  )
  def customized(
      customization: IvschatAsyncClientBuilder => IvschatAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Ivschat] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: IvschatAsyncClientBuilder => IvschatAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, Ivschat] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = IvschatAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[IvschatAsyncClient, IvschatAsyncClientBuilder](
      builder
    );
    b1 <- awsConfig
      .configureHttpClient[IvschatAsyncClient, IvschatAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
  ) yield new IvschatImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class IvschatImpl[R](
      override val api: IvschatAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Ivschat
      with AwsServiceBase[R] {
    override val serviceName: String = "Ivschat"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): IvschatImpl[R1] = new IvschatImpl(api, newAspect, r)
    def sendEvent(
        request: zio.aws.ivschat.model.SendEventRequest
    ): IO[AwsError, zio.aws.ivschat.model.SendEventResponse.ReadOnly] =
      asyncRequestResponse[SendEventRequest, SendEventResponse](
        "sendEvent",
        api.sendEvent
      )(request.buildAwsValue())
        .map(zio.aws.ivschat.model.SendEventResponse.wrap)
        .provideEnvironment(r)
    def updateRoom(
        request: zio.aws.ivschat.model.UpdateRoomRequest
    ): IO[AwsError, zio.aws.ivschat.model.UpdateRoomResponse.ReadOnly] =
      asyncRequestResponse[UpdateRoomRequest, UpdateRoomResponse](
        "updateRoom",
        api.updateRoom
      )(request.buildAwsValue())
        .map(zio.aws.ivschat.model.UpdateRoomResponse.wrap)
        .provideEnvironment(r)
    def deleteMessage(
        request: zio.aws.ivschat.model.DeleteMessageRequest
    ): IO[AwsError, zio.aws.ivschat.model.DeleteMessageResponse.ReadOnly] =
      asyncRequestResponse[DeleteMessageRequest, DeleteMessageResponse](
        "deleteMessage",
        api.deleteMessage
      )(request.buildAwsValue())
        .map(zio.aws.ivschat.model.DeleteMessageResponse.wrap)
        .provideEnvironment(r)
    def createChatToken(
        request: zio.aws.ivschat.model.CreateChatTokenRequest
    ): IO[AwsError, zio.aws.ivschat.model.CreateChatTokenResponse.ReadOnly] =
      asyncRequestResponse[CreateChatTokenRequest, CreateChatTokenResponse](
        "createChatToken",
        api.createChatToken
      )(request.buildAwsValue())
        .map(zio.aws.ivschat.model.CreateChatTokenResponse.wrap)
        .provideEnvironment(r)
    def disconnectUser(
        request: zio.aws.ivschat.model.DisconnectUserRequest
    ): IO[AwsError, ReadOnly] =
      asyncRequestResponse[DisconnectUserRequest, DisconnectUserResponse](
        "disconnectUser",
        api.disconnectUser
      )(request.buildAwsValue())
        .map(zio.aws.ivschat.model.DisconnectUserResponse.wrap)
        .provideEnvironment(r)
    def createLoggingConfiguration(
        request: zio.aws.ivschat.model.CreateLoggingConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.ivschat.model.CreateLoggingConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateLoggingConfigurationRequest,
      CreateLoggingConfigurationResponse
    ]("createLoggingConfiguration", api.createLoggingConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.ivschat.model.CreateLoggingConfigurationResponse.wrap)
      .provideEnvironment(r)
    def updateLoggingConfiguration(
        request: zio.aws.ivschat.model.UpdateLoggingConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.ivschat.model.UpdateLoggingConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateLoggingConfigurationRequest,
      UpdateLoggingConfigurationResponse
    ]("updateLoggingConfiguration", api.updateLoggingConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.ivschat.model.UpdateLoggingConfigurationResponse.wrap)
      .provideEnvironment(r)
    def untagResource(
        request: zio.aws.ivschat.model.UntagResourceRequest
    ): IO[AwsError, zio.aws.ivschat.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[UntagResourceRequest, UntagResourceResponse](
        "untagResource",
        api.untagResource
      )(request.buildAwsValue())
        .map(zio.aws.ivschat.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def createRoom(
        request: zio.aws.ivschat.model.CreateRoomRequest
    ): IO[AwsError, zio.aws.ivschat.model.CreateRoomResponse.ReadOnly] =
      asyncRequestResponse[CreateRoomRequest, CreateRoomResponse](
        "createRoom",
        api.createRoom
      )(request.buildAwsValue())
        .map(zio.aws.ivschat.model.CreateRoomResponse.wrap)
        .provideEnvironment(r)
    def deleteRoom(
        request: zio.aws.ivschat.model.DeleteRoomRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteRoomRequest, DeleteRoomResponse](
        "deleteRoom",
        api.deleteRoom
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def getLoggingConfiguration(
        request: zio.aws.ivschat.model.GetLoggingConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.ivschat.model.GetLoggingConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      GetLoggingConfigurationRequest,
      GetLoggingConfigurationResponse
    ]("getLoggingConfiguration", api.getLoggingConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.ivschat.model.GetLoggingConfigurationResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(
        request: zio.aws.ivschat.model.ListTagsForResourceRequest
    ): IO[
      AwsError,
      zio.aws.ivschat.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.ivschat.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def tagResource(
        request: zio.aws.ivschat.model.TagResourceRequest
    ): IO[AwsError, zio.aws.ivschat.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[TagResourceRequest, TagResourceResponse](
        "tagResource",
        api.tagResource
      )(request.buildAwsValue())
        .map(zio.aws.ivschat.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def listLoggingConfigurations(
        request: zio.aws.ivschat.model.ListLoggingConfigurationsRequest
    ): IO[
      AwsError,
      zio.aws.ivschat.model.ListLoggingConfigurationsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListLoggingConfigurationsRequest,
      ListLoggingConfigurationsResponse
    ]("listLoggingConfigurations", api.listLoggingConfigurations)(
      request.buildAwsValue()
    ).map(zio.aws.ivschat.model.ListLoggingConfigurationsResponse.wrap)
      .provideEnvironment(r)
    def getRoom(
        request: zio.aws.ivschat.model.GetRoomRequest
    ): IO[AwsError, zio.aws.ivschat.model.GetRoomResponse.ReadOnly] =
      asyncRequestResponse[GetRoomRequest, GetRoomResponse](
        "getRoom",
        api.getRoom
      )(request.buildAwsValue())
        .map(zio.aws.ivschat.model.GetRoomResponse.wrap)
        .provideEnvironment(r)
    def deleteLoggingConfiguration(
        request: zio.aws.ivschat.model.DeleteLoggingConfigurationRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteLoggingConfigurationRequest,
      DeleteLoggingConfigurationResponse
    ]("deleteLoggingConfiguration", api.deleteLoggingConfiguration)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listRooms(
        request: zio.aws.ivschat.model.ListRoomsRequest
    ): IO[AwsError, zio.aws.ivschat.model.ListRoomsResponse.ReadOnly] =
      asyncRequestResponse[ListRoomsRequest, ListRoomsResponse](
        "listRooms",
        api.listRooms
      )(request.buildAwsValue())
        .map(zio.aws.ivschat.model.ListRoomsResponse.wrap)
        .provideEnvironment(r)
  }
  def sendEvent(request: zio.aws.ivschat.model.SendEventRequest): ZIO[
    zio.aws.ivschat.Ivschat,
    AwsError,
    zio.aws.ivschat.model.SendEventResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.sendEvent(request))
  def updateRoom(request: zio.aws.ivschat.model.UpdateRoomRequest): ZIO[
    zio.aws.ivschat.Ivschat,
    AwsError,
    zio.aws.ivschat.model.UpdateRoomResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateRoom(request))
  def deleteMessage(request: zio.aws.ivschat.model.DeleteMessageRequest): ZIO[
    zio.aws.ivschat.Ivschat,
    AwsError,
    zio.aws.ivschat.model.DeleteMessageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteMessage(request))
  def createChatToken(
      request: zio.aws.ivschat.model.CreateChatTokenRequest
  ): ZIO[
    zio.aws.ivschat.Ivschat,
    AwsError,
    zio.aws.ivschat.model.CreateChatTokenResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createChatToken(request))
  def disconnectUser(
      request: zio.aws.ivschat.model.DisconnectUserRequest
  ): ZIO[zio.aws.ivschat.Ivschat, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.disconnectUser(request))
  def createLoggingConfiguration(
      request: zio.aws.ivschat.model.CreateLoggingConfigurationRequest
  ): ZIO[
    zio.aws.ivschat.Ivschat,
    AwsError,
    zio.aws.ivschat.model.CreateLoggingConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createLoggingConfiguration(request))
  def updateLoggingConfiguration(
      request: zio.aws.ivschat.model.UpdateLoggingConfigurationRequest
  ): ZIO[
    zio.aws.ivschat.Ivschat,
    AwsError,
    zio.aws.ivschat.model.UpdateLoggingConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateLoggingConfiguration(request))
  def untagResource(request: zio.aws.ivschat.model.UntagResourceRequest): ZIO[
    zio.aws.ivschat.Ivschat,
    AwsError,
    zio.aws.ivschat.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def createRoom(request: zio.aws.ivschat.model.CreateRoomRequest): ZIO[
    zio.aws.ivschat.Ivschat,
    AwsError,
    zio.aws.ivschat.model.CreateRoomResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createRoom(request))
  def deleteRoom(
      request: zio.aws.ivschat.model.DeleteRoomRequest
  ): ZIO[zio.aws.ivschat.Ivschat, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteRoom(request))
  def getLoggingConfiguration(
      request: zio.aws.ivschat.model.GetLoggingConfigurationRequest
  ): ZIO[
    zio.aws.ivschat.Ivschat,
    AwsError,
    zio.aws.ivschat.model.GetLoggingConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getLoggingConfiguration(request))
  def listTagsForResource(
      request: zio.aws.ivschat.model.ListTagsForResourceRequest
  ): ZIO[
    zio.aws.ivschat.Ivschat,
    AwsError,
    zio.aws.ivschat.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def tagResource(request: zio.aws.ivschat.model.TagResourceRequest): ZIO[
    zio.aws.ivschat.Ivschat,
    AwsError,
    zio.aws.ivschat.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def listLoggingConfigurations(
      request: zio.aws.ivschat.model.ListLoggingConfigurationsRequest
  ): ZIO[
    zio.aws.ivschat.Ivschat,
    AwsError,
    zio.aws.ivschat.model.ListLoggingConfigurationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listLoggingConfigurations(request))
  def getRoom(request: zio.aws.ivschat.model.GetRoomRequest): ZIO[
    zio.aws.ivschat.Ivschat,
    AwsError,
    zio.aws.ivschat.model.GetRoomResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getRoom(request))
  def deleteLoggingConfiguration(
      request: zio.aws.ivschat.model.DeleteLoggingConfigurationRequest
  ): ZIO[zio.aws.ivschat.Ivschat, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteLoggingConfiguration(request))
  def listRooms(request: zio.aws.ivschat.model.ListRoomsRequest): ZIO[
    zio.aws.ivschat.Ivschat,
    AwsError,
    zio.aws.ivschat.model.ListRoomsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listRooms(request))
}
