package zio.aws.ivschat.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.ivschat.model.primitives.BucketName
import scala.jdk.CollectionConverters.*
final case class S3DestinationConfiguration(bucketName: BucketName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivschat.model.S3DestinationConfiguration = {
    import S3DestinationConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivschat.model.S3DestinationConfiguration
      .builder()
      .bucketName(BucketName.unwrap(bucketName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ivschat.model.S3DestinationConfiguration.ReadOnly =
    zio.aws.ivschat.model.S3DestinationConfiguration.wrap(buildAwsValue())
}
object S3DestinationConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivschat.model.S3DestinationConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivschat.model.S3DestinationConfiguration =
      zio.aws.ivschat.model.S3DestinationConfiguration(bucketName)
    def bucketName: BucketName
    def getBucketName: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucketName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivschat.model.S3DestinationConfiguration
  ) extends zio.aws.ivschat.model.S3DestinationConfiguration.ReadOnly {
    override val bucketName: BucketName =
      zio.aws.ivschat.model.primitives.BucketName(impl.bucketName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivschat.model.S3DestinationConfiguration
  ): zio.aws.ivschat.model.S3DestinationConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
