package zio.aws.ivschat.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DestinationConfiguration(
    cloudWatchLogs: Optional[
      zio.aws.ivschat.model.CloudWatchLogsDestinationConfiguration
    ] = Optional.Absent,
    firehose: Optional[zio.aws.ivschat.model.FirehoseDestinationConfiguration] =
      Optional.Absent,
    s3: Optional[zio.aws.ivschat.model.S3DestinationConfiguration] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivschat.model.DestinationConfiguration = {
    import DestinationConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivschat.model.DestinationConfiguration
      .builder()
      .optionallyWith(cloudWatchLogs.map(value => value.buildAwsValue()))(
        _.cloudWatchLogs
      )
      .optionallyWith(firehose.map(value => value.buildAwsValue()))(_.firehose)
      .optionallyWith(s3.map(value => value.buildAwsValue()))(_.s3)
      .build()
  }
  def asReadOnly: zio.aws.ivschat.model.DestinationConfiguration.ReadOnly =
    zio.aws.ivschat.model.DestinationConfiguration.wrap(buildAwsValue())
}
object DestinationConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivschat.model.DestinationConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivschat.model.DestinationConfiguration =
      zio.aws.ivschat.model.DestinationConfiguration(
        cloudWatchLogs.map(value => value.asEditable),
        firehose.map(value => value.asEditable),
        s3.map(value => value.asEditable)
      )
    def cloudWatchLogs: Optional[
      zio.aws.ivschat.model.CloudWatchLogsDestinationConfiguration.ReadOnly
    ]
    def firehose: Optional[
      zio.aws.ivschat.model.FirehoseDestinationConfiguration.ReadOnly
    ]
    def s3: Optional[zio.aws.ivschat.model.S3DestinationConfiguration.ReadOnly]
    def getCloudWatchLogs: ZIO[
      Any,
      AwsError,
      zio.aws.ivschat.model.CloudWatchLogsDestinationConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("cloudWatchLogs", cloudWatchLogs)
    def getFirehose: ZIO[
      Any,
      AwsError,
      zio.aws.ivschat.model.FirehoseDestinationConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("firehose", firehose)
    def getS3: ZIO[
      Any,
      AwsError,
      zio.aws.ivschat.model.S3DestinationConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("s3", s3)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivschat.model.DestinationConfiguration
  ) extends zio.aws.ivschat.model.DestinationConfiguration.ReadOnly {
    override val cloudWatchLogs: Optional[
      zio.aws.ivschat.model.CloudWatchLogsDestinationConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.cloudWatchLogs())
      .map(value =>
        zio.aws.ivschat.model.CloudWatchLogsDestinationConfiguration.wrap(value)
      )
    override val firehose: Optional[
      zio.aws.ivschat.model.FirehoseDestinationConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.firehose())
      .map(value =>
        zio.aws.ivschat.model.FirehoseDestinationConfiguration.wrap(value)
      )
    override val s3
        : Optional[zio.aws.ivschat.model.S3DestinationConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3())
        .map(value =>
          zio.aws.ivschat.model.S3DestinationConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivschat.model.DestinationConfiguration
  ): zio.aws.ivschat.model.DestinationConfiguration.ReadOnly = new Wrapper(impl)
}
