package zio.aws.ivschat.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.ivschat.model.primitives.ID
import scala.jdk.CollectionConverters.*
final case class DeleteMessageResponse(id: Optional[ID] = Optional.Absent) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivschat.model.DeleteMessageResponse = {
    import DeleteMessageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivschat.model.DeleteMessageResponse
      .builder()
      .optionallyWith(id.map(value => ID.unwrap(value): java.lang.String))(_.id)
      .build()
  }
  def asReadOnly: zio.aws.ivschat.model.DeleteMessageResponse.ReadOnly =
    zio.aws.ivschat.model.DeleteMessageResponse.wrap(buildAwsValue())
}
object DeleteMessageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivschat.model.DeleteMessageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivschat.model.DeleteMessageResponse =
      zio.aws.ivschat.model.DeleteMessageResponse(id.map(value => value))
    def id: Optional[ID]
    def getId: ZIO[Any, AwsError, ID] = AwsError.unwrapOptionField("id", id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivschat.model.DeleteMessageResponse
  ) extends zio.aws.ivschat.model.DeleteMessageResponse.ReadOnly {
    override val id: Optional[ID] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.ivschat.model.primitives.ID(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivschat.model.DeleteMessageResponse
  ): zio.aws.ivschat.model.DeleteMessageResponse.ReadOnly = new Wrapper(impl)
}
