package zio.aws.ivschat.model
import zio.aws.ivschat.model.primitives.{
  Time,
  LoggingConfigurationID,
  LoggingConfigurationArn,
  TagValue,
  LoggingConfigurationName,
  TagKey
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class CreateLoggingConfigurationResponse(
    arn: Optional[LoggingConfigurationArn] = Optional.Absent,
    createTime: Optional[Time] = Optional.Absent,
    destinationConfiguration: Optional[
      zio.aws.ivschat.model.DestinationConfiguration
    ] = Optional.Absent,
    id: Optional[LoggingConfigurationID] = Optional.Absent,
    name: Optional[LoggingConfigurationName] = Optional.Absent,
    state: Optional[zio.aws.ivschat.model.CreateLoggingConfigurationState] =
      Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    updateTime: Optional[Time] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivschat.model.CreateLoggingConfigurationResponse = {
    import CreateLoggingConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivschat.model.CreateLoggingConfigurationResponse
      .builder()
      .optionallyWith(
        arn.map(value =>
          LoggingConfigurationArn.unwrap(value): java.lang.String
        )
      )(_.arn)
      .optionallyWith(createTime.map(value => Time.unwrap(value): Instant))(
        _.createTime
      )
      .optionallyWith(
        destinationConfiguration.map(value => value.buildAwsValue())
      )(_.destinationConfiguration)
      .optionallyWith(
        id.map(value => LoggingConfigurationID.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        name.map(value =>
          LoggingConfigurationName.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(updateTime.map(value => Time.unwrap(value): Instant))(
        _.updateTime
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ivschat.model.CreateLoggingConfigurationResponse.ReadOnly =
    zio.aws.ivschat.model.CreateLoggingConfigurationResponse
      .wrap(buildAwsValue())
}
object CreateLoggingConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivschat.model.CreateLoggingConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivschat.model.CreateLoggingConfigurationResponse =
      zio.aws.ivschat.model.CreateLoggingConfigurationResponse(
        arn.map(value => value),
        createTime.map(value => value),
        destinationConfiguration.map(value => value.asEditable),
        id.map(value => value),
        name.map(value => value),
        state.map(value => value),
        tags.map(value => value),
        updateTime.map(value => value)
      )
    def arn: Optional[LoggingConfigurationArn]
    def createTime: Optional[Time]
    def destinationConfiguration
        : Optional[zio.aws.ivschat.model.DestinationConfiguration.ReadOnly]
    def id: Optional[LoggingConfigurationID]
    def name: Optional[LoggingConfigurationName]
    def state: Optional[zio.aws.ivschat.model.CreateLoggingConfigurationState]
    def tags: Optional[Map[TagKey, TagValue]]
    def updateTime: Optional[Time]
    def getArn: ZIO[Any, AwsError, LoggingConfigurationArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreateTime: ZIO[Any, AwsError, Time] =
      AwsError.unwrapOptionField("createTime", createTime)
    def getDestinationConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.ivschat.model.DestinationConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "destinationConfiguration",
      destinationConfiguration
    )
    def getId: ZIO[Any, AwsError, LoggingConfigurationID] =
      AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, LoggingConfigurationName] =
      AwsError.unwrapOptionField("name", name)
    def getState: ZIO[
      Any,
      AwsError,
      zio.aws.ivschat.model.CreateLoggingConfigurationState
    ] = AwsError.unwrapOptionField("state", state)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getUpdateTime: ZIO[Any, AwsError, Time] =
      AwsError.unwrapOptionField("updateTime", updateTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivschat.model.CreateLoggingConfigurationResponse
  ) extends zio.aws.ivschat.model.CreateLoggingConfigurationResponse.ReadOnly {
    override val arn: Optional[LoggingConfigurationArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value =>
        zio.aws.ivschat.model.primitives.LoggingConfigurationArn(value)
      )
    override val createTime: Optional[Time] = zio.aws.core.internal
      .optionalFromNullable(impl.createTime())
      .map(value => zio.aws.ivschat.model.primitives.Time(value))
    override val destinationConfiguration
        : Optional[zio.aws.ivschat.model.DestinationConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationConfiguration())
        .map(value =>
          zio.aws.ivschat.model.DestinationConfiguration.wrap(value)
        )
    override val id: Optional[LoggingConfigurationID] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value =>
        zio.aws.ivschat.model.primitives.LoggingConfigurationID(value)
      )
    override val name: Optional[LoggingConfigurationName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value =>
          zio.aws.ivschat.model.primitives.LoggingConfigurationName(value)
        )
    override val state
        : Optional[zio.aws.ivschat.model.CreateLoggingConfigurationState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value =>
          zio.aws.ivschat.model.CreateLoggingConfigurationState.wrap(value)
        )
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.ivschat.model.primitives
              .TagKey(key) -> zio.aws.ivschat.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val updateTime: Optional[Time] = zio.aws.core.internal
      .optionalFromNullable(impl.updateTime())
      .map(value => zio.aws.ivschat.model.primitives.Time(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivschat.model.CreateLoggingConfigurationResponse
  ): zio.aws.ivschat.model.CreateLoggingConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
