package zio.aws.ivs.model
import zio.aws.ivs.model.primitives.{
  ChannelRecordingConfigurationArn,
  ChannelName,
  ChannelArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateChannelRequest(
    arn: ChannelArn,
    authorized: Optional[Boolean] = Optional.Absent,
    insecureIngest: Optional[Boolean] = Optional.Absent,
    latencyMode: Optional[zio.aws.ivs.model.ChannelLatencyMode] =
      Optional.Absent,
    name: Optional[ChannelName] = Optional.Absent,
    preset: Optional[zio.aws.ivs.model.TranscodePreset] = Optional.Absent,
    recordingConfigurationArn: Optional[ChannelRecordingConfigurationArn] =
      Optional.Absent,
    `type`: Optional[zio.aws.ivs.model.ChannelType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivs.model.UpdateChannelRequest = {
    import UpdateChannelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivs.model.UpdateChannelRequest
      .builder()
      .arn(ChannelArn.unwrap(arn): java.lang.String)
      .optionallyWith(authorized.map(value => value: java.lang.Boolean))(
        _.authorized
      )
      .optionallyWith(insecureIngest.map(value => value: java.lang.Boolean))(
        _.insecureIngest
      )
      .optionallyWith(latencyMode.map(value => value.unwrap))(_.latencyMode)
      .optionallyWith(
        name.map(value => ChannelName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(preset.map(value => value.unwrap))(_.preset)
      .optionallyWith(
        recordingConfigurationArn.map(value =>
          ChannelRecordingConfigurationArn.unwrap(value): java.lang.String
        )
      )(_.recordingConfigurationArn)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.ivs.model.UpdateChannelRequest.ReadOnly =
    zio.aws.ivs.model.UpdateChannelRequest.wrap(buildAwsValue())
}
object UpdateChannelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivs.model.UpdateChannelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivs.model.UpdateChannelRequest =
      zio.aws.ivs.model.UpdateChannelRequest(
        arn,
        authorized.map(value => value),
        insecureIngest.map(value => value),
        latencyMode.map(value => value),
        name.map(value => value),
        preset.map(value => value),
        recordingConfigurationArn.map(value => value),
        `type`.map(value => value)
      )
    def arn: ChannelArn
    def authorized: Optional[Boolean]
    def insecureIngest: Optional[Boolean]
    def latencyMode: Optional[zio.aws.ivs.model.ChannelLatencyMode]
    def name: Optional[ChannelName]
    def preset: Optional[zio.aws.ivs.model.TranscodePreset]
    def recordingConfigurationArn: Optional[ChannelRecordingConfigurationArn]
    def `type`: Optional[zio.aws.ivs.model.ChannelType]
    def getArn: ZIO[Any, Nothing, ChannelArn] = ZIO.succeed(arn)
    def getAuthorized: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("authorized", authorized)
    def getInsecureIngest: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("insecureIngest", insecureIngest)
    def getLatencyMode
        : ZIO[Any, AwsError, zio.aws.ivs.model.ChannelLatencyMode] =
      AwsError.unwrapOptionField("latencyMode", latencyMode)
    def getName: ZIO[Any, AwsError, ChannelName] =
      AwsError.unwrapOptionField("name", name)
    def getPreset: ZIO[Any, AwsError, zio.aws.ivs.model.TranscodePreset] =
      AwsError.unwrapOptionField("preset", preset)
    def getRecordingConfigurationArn
        : ZIO[Any, AwsError, ChannelRecordingConfigurationArn] = AwsError
      .unwrapOptionField("recordingConfigurationArn", recordingConfigurationArn)
    def getType: ZIO[Any, AwsError, zio.aws.ivs.model.ChannelType] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivs.model.UpdateChannelRequest
  ) extends zio.aws.ivs.model.UpdateChannelRequest.ReadOnly {
    override val arn: ChannelArn =
      zio.aws.ivs.model.primitives.ChannelArn(impl.arn())
    override val authorized: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.authorized())
      .map(value => value: Boolean)
    override val insecureIngest: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.insecureIngest())
      .map(value => value: Boolean)
    override val latencyMode: Optional[zio.aws.ivs.model.ChannelLatencyMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.latencyMode())
        .map(value => zio.aws.ivs.model.ChannelLatencyMode.wrap(value))
    override val name: Optional[ChannelName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.ivs.model.primitives.ChannelName(value))
    override val preset: Optional[zio.aws.ivs.model.TranscodePreset] =
      zio.aws.core.internal
        .optionalFromNullable(impl.preset())
        .map(value => zio.aws.ivs.model.TranscodePreset.wrap(value))
    override val recordingConfigurationArn
        : Optional[ChannelRecordingConfigurationArn] = zio.aws.core.internal
      .optionalFromNullable(impl.recordingConfigurationArn())
      .map(value =>
        zio.aws.ivs.model.primitives.ChannelRecordingConfigurationArn(value)
      )
    override val `type`: Optional[zio.aws.ivs.model.ChannelType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.ivs.model.ChannelType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivs.model.UpdateChannelRequest
  ): zio.aws.ivs.model.UpdateChannelRequest.ReadOnly = new Wrapper(impl)
}
