package zio.aws.ivs.model
import zio.aws.ivs.model.primitives.{TagKey, ResourceArn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UntagResourceRequest(
    resourceArn: ResourceArn,
    tagKeys: Iterable[TagKey]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivs.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivs.model.UntagResourceRequest
      .builder()
      .resourceArn(ResourceArn.unwrap(resourceArn): java.lang.String)
      .tagKeys(tagKeys.map { item =>
        TagKey.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.ivs.model.UntagResourceRequest.ReadOnly =
    zio.aws.ivs.model.UntagResourceRequest.wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivs.model.UntagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivs.model.UntagResourceRequest =
      zio.aws.ivs.model.UntagResourceRequest(resourceArn, tagKeys)
    def resourceArn: ResourceArn
    def tagKeys: List[TagKey]
    def getResourceArn: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(resourceArn)
    def getTagKeys: ZIO[Any, Nothing, List[TagKey]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivs.model.UntagResourceRequest
  ) extends zio.aws.ivs.model.UntagResourceRequest.ReadOnly {
    override val resourceArn: ResourceArn =
      zio.aws.ivs.model.primitives.ResourceArn(impl.resourceArn())
    override val tagKeys: List[TagKey] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.ivs.model.primitives.TagKey(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivs.model.UntagResourceRequest
  ): zio.aws.ivs.model.UntagResourceRequest.ReadOnly = new Wrapper(impl)
}
