package zio.aws.ivs.model
import scala.jdk.CollectionConverters._
sealed trait TranscodePreset {
  def unwrap: software.amazon.awssdk.services.ivs.model.TranscodePreset
}
object TranscodePreset {
  def wrap(
      value: software.amazon.awssdk.services.ivs.model.TranscodePreset
  ): zio.aws.ivs.model.TranscodePreset = value match {
    case software.amazon.awssdk.services.ivs.model.TranscodePreset.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ivs.model.TranscodePreset.HIGHER_BANDWIDTH_DELIVERY =>
      val r = HIGHER_BANDWIDTH_DELIVERY
      r
    case software.amazon.awssdk.services.ivs.model.TranscodePreset.CONSTRAINED_BANDWIDTH_DELIVERY =>
      val r = CONSTRAINED_BANDWIDTH_DELIVERY
      r
  }
  case object unknownToSdkVersion extends zio.aws.ivs.model.TranscodePreset {
    override def unwrap
        : software.amazon.awssdk.services.ivs.model.TranscodePreset =
      software.amazon.awssdk.services.ivs.model.TranscodePreset.UNKNOWN_TO_SDK_VERSION
  }
  case object HIGHER_BANDWIDTH_DELIVERY
      extends zio.aws.ivs.model.TranscodePreset {
    override def unwrap
        : software.amazon.awssdk.services.ivs.model.TranscodePreset =
      software.amazon.awssdk.services.ivs.model.TranscodePreset.HIGHER_BANDWIDTH_DELIVERY
  }
  case object CONSTRAINED_BANDWIDTH_DELIVERY
      extends zio.aws.ivs.model.TranscodePreset {
    override def unwrap
        : software.amazon.awssdk.services.ivs.model.TranscodePreset =
      software.amazon.awssdk.services.ivs.model.TranscodePreset.CONSTRAINED_BANDWIDTH_DELIVERY
  }
}
