package zio.aws.ivs.model
import scala.jdk.CollectionConverters._
sealed trait StreamState {
  def unwrap: software.amazon.awssdk.services.ivs.model.StreamState
}
object StreamState {
  def wrap(
      value: software.amazon.awssdk.services.ivs.model.StreamState
  ): zio.aws.ivs.model.StreamState = value match {
    case software.amazon.awssdk.services.ivs.model.StreamState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ivs.model.StreamState.LIVE =>
      val r = LIVE
      r
    case software.amazon.awssdk.services.ivs.model.StreamState.OFFLINE =>
      val r = OFFLINE
      r
  }
  case object unknownToSdkVersion extends zio.aws.ivs.model.StreamState {
    override def unwrap: software.amazon.awssdk.services.ivs.model.StreamState =
      software.amazon.awssdk.services.ivs.model.StreamState.UNKNOWN_TO_SDK_VERSION
  }
  case object LIVE extends zio.aws.ivs.model.StreamState {
    override def unwrap: software.amazon.awssdk.services.ivs.model.StreamState =
      software.amazon.awssdk.services.ivs.model.StreamState.LIVE
  }
  case object OFFLINE extends zio.aws.ivs.model.StreamState {
    override def unwrap: software.amazon.awssdk.services.ivs.model.StreamState =
      software.amazon.awssdk.services.ivs.model.StreamState.OFFLINE
  }
}
