package zio.aws.ivs.model
import zio.aws.ivs.model.primitives.{
  StreamKeyValue,
  TagValue,
  StreamKeyArn,
  ChannelArn,
  TagKey
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StreamKey(
    arn: Optional[StreamKeyArn] = Optional.Absent,
    channelArn: Optional[ChannelArn] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    value: Optional[StreamKeyValue] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ivs.model.StreamKey = {
    import StreamKey.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivs.model.StreamKey
      .builder()
      .optionallyWith(
        arn.map(value => StreamKeyArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        channelArn.map(value => ChannelArn.unwrap(value): java.lang.String)
      )(_.channelArn)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        value.map(value => StreamKeyValue.unwrap(value): java.lang.String)
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.ivs.model.StreamKey.ReadOnly =
    zio.aws.ivs.model.StreamKey.wrap(buildAwsValue())
}
object StreamKey {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ivs.model.StreamKey] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivs.model.StreamKey = zio.aws.ivs.model.StreamKey(
      arn.map(value => value),
      channelArn.map(value => value),
      tags.map(value => value),
      value.map(value => value)
    )
    def arn: Optional[StreamKeyArn]
    def channelArn: Optional[ChannelArn]
    def tags: Optional[Map[TagKey, TagValue]]
    def value: Optional[StreamKeyValue]
    def getArn: ZIO[Any, AwsError, StreamKeyArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getChannelArn: ZIO[Any, AwsError, ChannelArn] =
      AwsError.unwrapOptionField("channelArn", channelArn)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getValue: ZIO[Any, AwsError, StreamKeyValue] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivs.model.StreamKey
  ) extends zio.aws.ivs.model.StreamKey.ReadOnly {
    override val arn: Optional[StreamKeyArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.ivs.model.primitives.StreamKeyArn(value))
    override val channelArn: Optional[ChannelArn] = zio.aws.core.internal
      .optionalFromNullable(impl.channelArn())
      .map(value => zio.aws.ivs.model.primitives.ChannelArn(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.ivs.model.primitives
              .TagKey(key) -> zio.aws.ivs.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val value: Optional[StreamKeyValue] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => zio.aws.ivs.model.primitives.StreamKeyValue(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivs.model.StreamKey
  ): zio.aws.ivs.model.StreamKey.ReadOnly = new Wrapper(impl)
}
