package zio.aws.ivs.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ivs.model.primitives.{PaginationToken, MaxPlaybackKeyPairResults}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListPlaybackKeyPairsRequest(
    maxResults: Optional[MaxPlaybackKeyPairResults] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivs.model.ListPlaybackKeyPairsRequest = {
    import ListPlaybackKeyPairsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivs.model.ListPlaybackKeyPairsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value =>
          MaxPlaybackKeyPairResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ivs.model.ListPlaybackKeyPairsRequest.ReadOnly =
    zio.aws.ivs.model.ListPlaybackKeyPairsRequest.wrap(buildAwsValue())
}
object ListPlaybackKeyPairsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivs.model.ListPlaybackKeyPairsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivs.model.ListPlaybackKeyPairsRequest =
      zio.aws.ivs.model.ListPlaybackKeyPairsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Optional[MaxPlaybackKeyPairResults]
    def nextToken: Optional[PaginationToken]
    def getMaxResults: ZIO[Any, AwsError, MaxPlaybackKeyPairResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivs.model.ListPlaybackKeyPairsRequest
  ) extends zio.aws.ivs.model.ListPlaybackKeyPairsRequest.ReadOnly {
    override val maxResults: Optional[MaxPlaybackKeyPairResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.ivs.model.primitives.MaxPlaybackKeyPairResults(value)
        )
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ivs.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivs.model.ListPlaybackKeyPairsRequest
  ): zio.aws.ivs.model.ListPlaybackKeyPairsRequest.ReadOnly = new Wrapper(impl)
}
