package zio.aws.ivs.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ivs.model.primitives.{
  PaginationToken,
  MaxChannelResults,
  ChannelRecordingConfigurationArn,
  ChannelName
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListChannelsRequest(
    filterByName: Optional[ChannelName] = Optional.Absent,
    filterByRecordingConfigurationArn: Optional[
      ChannelRecordingConfigurationArn
    ] = Optional.Absent,
    maxResults: Optional[MaxChannelResults] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivs.model.ListChannelsRequest = {
    import ListChannelsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivs.model.ListChannelsRequest
      .builder()
      .optionallyWith(
        filterByName.map(value => ChannelName.unwrap(value): java.lang.String)
      )(_.filterByName)
      .optionallyWith(
        filterByRecordingConfigurationArn.map(value =>
          ChannelRecordingConfigurationArn.unwrap(value): java.lang.String
        )
      )(_.filterByRecordingConfigurationArn)
      .optionallyWith(
        maxResults.map(value => MaxChannelResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ivs.model.ListChannelsRequest.ReadOnly =
    zio.aws.ivs.model.ListChannelsRequest.wrap(buildAwsValue())
}
object ListChannelsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivs.model.ListChannelsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivs.model.ListChannelsRequest =
      zio.aws.ivs.model.ListChannelsRequest(
        filterByName.map(value => value),
        filterByRecordingConfigurationArn.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def filterByName: Optional[ChannelName]
    def filterByRecordingConfigurationArn
        : Optional[ChannelRecordingConfigurationArn]
    def maxResults: Optional[MaxChannelResults]
    def nextToken: Optional[PaginationToken]
    def getFilterByName: ZIO[Any, AwsError, ChannelName] =
      AwsError.unwrapOptionField("filterByName", filterByName)
    def getFilterByRecordingConfigurationArn
        : ZIO[Any, AwsError, ChannelRecordingConfigurationArn] =
      AwsError.unwrapOptionField(
        "filterByRecordingConfigurationArn",
        filterByRecordingConfigurationArn
      )
    def getMaxResults: ZIO[Any, AwsError, MaxChannelResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivs.model.ListChannelsRequest
  ) extends zio.aws.ivs.model.ListChannelsRequest.ReadOnly {
    override val filterByName: Optional[ChannelName] = zio.aws.core.internal
      .optionalFromNullable(impl.filterByName())
      .map(value => zio.aws.ivs.model.primitives.ChannelName(value))
    override val filterByRecordingConfigurationArn
        : Optional[ChannelRecordingConfigurationArn] = zio.aws.core.internal
      .optionalFromNullable(impl.filterByRecordingConfigurationArn())
      .map(value =>
        zio.aws.ivs.model.primitives.ChannelRecordingConfigurationArn(value)
      )
    override val maxResults: Optional[MaxChannelResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.ivs.model.primitives.MaxChannelResults(value))
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ivs.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivs.model.ListChannelsRequest
  ): zio.aws.ivs.model.ListChannelsRequest.ReadOnly = new Wrapper(impl)
}
