package zio.aws.ivs.model
import scala.jdk.CollectionConverters._
sealed trait ThumbnailConfigurationStorage {
  def unwrap
      : software.amazon.awssdk.services.ivs.model.ThumbnailConfigurationStorage
}
object ThumbnailConfigurationStorage {
  def wrap(
      value: software.amazon.awssdk.services.ivs.model.ThumbnailConfigurationStorage
  ): zio.aws.ivs.model.ThumbnailConfigurationStorage = value match {
    case software.amazon.awssdk.services.ivs.model.ThumbnailConfigurationStorage.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ivs.model.ThumbnailConfigurationStorage.SEQUENTIAL =>
      val r = SEQUENTIAL
      r
    case software.amazon.awssdk.services.ivs.model.ThumbnailConfigurationStorage.LATEST =>
      val r = LATEST
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ivs.model.ThumbnailConfigurationStorage {
    override def unwrap
        : software.amazon.awssdk.services.ivs.model.ThumbnailConfigurationStorage =
      software.amazon.awssdk.services.ivs.model.ThumbnailConfigurationStorage.UNKNOWN_TO_SDK_VERSION
  }
  case object SEQUENTIAL
      extends zio.aws.ivs.model.ThumbnailConfigurationStorage {
    override def unwrap
        : software.amazon.awssdk.services.ivs.model.ThumbnailConfigurationStorage =
      software.amazon.awssdk.services.ivs.model.ThumbnailConfigurationStorage.SEQUENTIAL
  }
  case object LATEST extends zio.aws.ivs.model.ThumbnailConfigurationStorage {
    override def unwrap
        : software.amazon.awssdk.services.ivs.model.ThumbnailConfigurationStorage =
      software.amazon.awssdk.services.ivs.model.ThumbnailConfigurationStorage.LATEST
  }
}
