package zio.aws.ivs.model
import scala.jdk.CollectionConverters._
sealed trait ThumbnailConfigurationResolution {
  def unwrap: software.amazon.awssdk.services.ivs.model.ThumbnailConfigurationResolution
}
object ThumbnailConfigurationResolution {
  def wrap(
      value: software.amazon.awssdk.services.ivs.model.ThumbnailConfigurationResolution
  ): zio.aws.ivs.model.ThumbnailConfigurationResolution = value match {
    case software.amazon.awssdk.services.ivs.model.ThumbnailConfigurationResolution.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ivs.model.ThumbnailConfigurationResolution.FULL_HD =>
      val r = FULL_HD
      r
    case software.amazon.awssdk.services.ivs.model.ThumbnailConfigurationResolution.HD =>
      val r = HD
      r
    case software.amazon.awssdk.services.ivs.model.ThumbnailConfigurationResolution.SD =>
      val r = SD
      r
    case software.amazon.awssdk.services.ivs.model.ThumbnailConfigurationResolution.LOWEST_RESOLUTION =>
      val r = LOWEST_RESOLUTION
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ivs.model.ThumbnailConfigurationResolution {
    override def unwrap
        : software.amazon.awssdk.services.ivs.model.ThumbnailConfigurationResolution =
      software.amazon.awssdk.services.ivs.model.ThumbnailConfigurationResolution.UNKNOWN_TO_SDK_VERSION
  }
  case object FULL_HD
      extends zio.aws.ivs.model.ThumbnailConfigurationResolution {
    override def unwrap
        : software.amazon.awssdk.services.ivs.model.ThumbnailConfigurationResolution =
      software.amazon.awssdk.services.ivs.model.ThumbnailConfigurationResolution.FULL_HD
  }
  case object HD extends zio.aws.ivs.model.ThumbnailConfigurationResolution {
    override def unwrap
        : software.amazon.awssdk.services.ivs.model.ThumbnailConfigurationResolution =
      software.amazon.awssdk.services.ivs.model.ThumbnailConfigurationResolution.HD
  }
  case object SD extends zio.aws.ivs.model.ThumbnailConfigurationResolution {
    override def unwrap
        : software.amazon.awssdk.services.ivs.model.ThumbnailConfigurationResolution =
      software.amazon.awssdk.services.ivs.model.ThumbnailConfigurationResolution.SD
  }
  case object LOWEST_RESOLUTION
      extends zio.aws.ivs.model.ThumbnailConfigurationResolution {
    override def unwrap
        : software.amazon.awssdk.services.ivs.model.ThumbnailConfigurationResolution =
      software.amazon.awssdk.services.ivs.model.ThumbnailConfigurationResolution.LOWEST_RESOLUTION
  }
}
