package zio.aws.ivs.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ivs.model.primitives.{ViewerSessionVersion, ViewerId, ChannelArn}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class StartViewerSessionRevocationRequest(
    channelArn: ChannelArn,
    viewerId: ViewerId,
    viewerSessionVersionsLessThanOrEqualTo: Optional[ViewerSessionVersion] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivs.model.StartViewerSessionRevocationRequest = {
    import StartViewerSessionRevocationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivs.model.StartViewerSessionRevocationRequest
      .builder()
      .channelArn(ChannelArn.unwrap(channelArn): java.lang.String)
      .viewerId(ViewerId.unwrap(viewerId): java.lang.String)
      .optionallyWith(
        viewerSessionVersionsLessThanOrEqualTo.map(value =>
          ViewerSessionVersion.unwrap(value): Integer
        )
      )(_.viewerSessionVersionsLessThanOrEqualTo)
      .build()
  }
  def asReadOnly
      : zio.aws.ivs.model.StartViewerSessionRevocationRequest.ReadOnly =
    zio.aws.ivs.model.StartViewerSessionRevocationRequest.wrap(buildAwsValue())
}
object StartViewerSessionRevocationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivs.model.StartViewerSessionRevocationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivs.model.StartViewerSessionRevocationRequest =
      zio.aws.ivs.model.StartViewerSessionRevocationRequest(
        channelArn,
        viewerId,
        viewerSessionVersionsLessThanOrEqualTo.map(value => value)
      )
    def channelArn: ChannelArn
    def viewerId: ViewerId
    def viewerSessionVersionsLessThanOrEqualTo: Optional[ViewerSessionVersion]
    def getChannelArn: ZIO[Any, Nothing, ChannelArn] = ZIO.succeed(channelArn)
    def getViewerId: ZIO[Any, Nothing, ViewerId] = ZIO.succeed(viewerId)
    def getViewerSessionVersionsLessThanOrEqualTo
        : ZIO[Any, AwsError, ViewerSessionVersion] = AwsError.unwrapOptionField(
      "viewerSessionVersionsLessThanOrEqualTo",
      viewerSessionVersionsLessThanOrEqualTo
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivs.model.StartViewerSessionRevocationRequest
  ) extends zio.aws.ivs.model.StartViewerSessionRevocationRequest.ReadOnly {
    override val channelArn: ChannelArn =
      zio.aws.ivs.model.primitives.ChannelArn(impl.channelArn())
    override val viewerId: ViewerId =
      zio.aws.ivs.model.primitives.ViewerId(impl.viewerId())
    override val viewerSessionVersionsLessThanOrEqualTo
        : Optional[ViewerSessionVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.viewerSessionVersionsLessThanOrEqualTo())
      .map(value => zio.aws.ivs.model.primitives.ViewerSessionVersion(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivs.model.StartViewerSessionRevocationRequest
  ): zio.aws.ivs.model.StartViewerSessionRevocationRequest.ReadOnly =
    new Wrapper(impl)
}
