package zio.aws.ivs.model
import scala.jdk.CollectionConverters._
sealed trait RenditionConfigurationRendition {
  def unwrap: software.amazon.awssdk.services.ivs.model.RenditionConfigurationRendition
}
object RenditionConfigurationRendition {
  def wrap(
      value: software.amazon.awssdk.services.ivs.model.RenditionConfigurationRendition
  ): zio.aws.ivs.model.RenditionConfigurationRendition = value match {
    case software.amazon.awssdk.services.ivs.model.RenditionConfigurationRendition.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ivs.model.RenditionConfigurationRendition.FULL_HD =>
      val r = FULL_HD
      r
    case software.amazon.awssdk.services.ivs.model.RenditionConfigurationRendition.HD =>
      val r = HD
      r
    case software.amazon.awssdk.services.ivs.model.RenditionConfigurationRendition.SD =>
      val r = SD
      r
    case software.amazon.awssdk.services.ivs.model.RenditionConfigurationRendition.LOWEST_RESOLUTION =>
      val r = LOWEST_RESOLUTION
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ivs.model.RenditionConfigurationRendition {
    override def unwrap
        : software.amazon.awssdk.services.ivs.model.RenditionConfigurationRendition =
      software.amazon.awssdk.services.ivs.model.RenditionConfigurationRendition.UNKNOWN_TO_SDK_VERSION
  }
  case object FULL_HD
      extends zio.aws.ivs.model.RenditionConfigurationRendition {
    override def unwrap
        : software.amazon.awssdk.services.ivs.model.RenditionConfigurationRendition =
      software.amazon.awssdk.services.ivs.model.RenditionConfigurationRendition.FULL_HD
  }
  case object HD extends zio.aws.ivs.model.RenditionConfigurationRendition {
    override def unwrap
        : software.amazon.awssdk.services.ivs.model.RenditionConfigurationRendition =
      software.amazon.awssdk.services.ivs.model.RenditionConfigurationRendition.HD
  }
  case object SD extends zio.aws.ivs.model.RenditionConfigurationRendition {
    override def unwrap
        : software.amazon.awssdk.services.ivs.model.RenditionConfigurationRendition =
      software.amazon.awssdk.services.ivs.model.RenditionConfigurationRendition.SD
  }
  case object LOWEST_RESOLUTION
      extends zio.aws.ivs.model.RenditionConfigurationRendition {
    override def unwrap
        : software.amazon.awssdk.services.ivs.model.RenditionConfigurationRendition =
      software.amazon.awssdk.services.ivs.model.RenditionConfigurationRendition.LOWEST_RESOLUTION
  }
}
