package zio.aws.ivs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class RenditionConfiguration(
    renditionSelection: Optional[
      zio.aws.ivs.model.RenditionConfigurationRenditionSelection
    ] = Optional.Absent,
    renditions: Optional[
      Iterable[zio.aws.ivs.model.RenditionConfigurationRendition]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivs.model.RenditionConfiguration = {
    import RenditionConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivs.model.RenditionConfiguration
      .builder()
      .optionallyWith(renditionSelection.map(value => value.unwrap))(
        _.renditionSelection
      )
      .optionallyWith(
        renditions.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.renditionsWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.ivs.model.RenditionConfiguration.ReadOnly =
    zio.aws.ivs.model.RenditionConfiguration.wrap(buildAwsValue())
}
object RenditionConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivs.model.RenditionConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivs.model.RenditionConfiguration =
      zio.aws.ivs.model.RenditionConfiguration(
        renditionSelection.map(value => value),
        renditions.map(value => value)
      )
    def renditionSelection
        : Optional[zio.aws.ivs.model.RenditionConfigurationRenditionSelection]
    def renditions
        : Optional[List[zio.aws.ivs.model.RenditionConfigurationRendition]]
    def getRenditionSelection: ZIO[
      Any,
      AwsError,
      zio.aws.ivs.model.RenditionConfigurationRenditionSelection
    ] = AwsError.unwrapOptionField("renditionSelection", renditionSelection)
    def getRenditions: ZIO[Any, AwsError, List[
      zio.aws.ivs.model.RenditionConfigurationRendition
    ]] = AwsError.unwrapOptionField("renditions", renditions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivs.model.RenditionConfiguration
  ) extends zio.aws.ivs.model.RenditionConfiguration.ReadOnly {
    override val renditionSelection
        : Optional[zio.aws.ivs.model.RenditionConfigurationRenditionSelection] =
      zio.aws.core.internal
        .optionalFromNullable(impl.renditionSelection())
        .map(value =>
          zio.aws.ivs.model.RenditionConfigurationRenditionSelection.wrap(value)
        )
    override val renditions
        : Optional[List[zio.aws.ivs.model.RenditionConfigurationRendition]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.renditions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ivs.model.RenditionConfigurationRendition.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivs.model.RenditionConfiguration
  ): zio.aws.ivs.model.RenditionConfiguration.ReadOnly = new Wrapper(impl)
}
