package zio.aws.ivs.model
import scala.jdk.CollectionConverters._
sealed trait RecordingConfigurationState {
  def unwrap
      : software.amazon.awssdk.services.ivs.model.RecordingConfigurationState
}
object RecordingConfigurationState {
  def wrap(
      value: software.amazon.awssdk.services.ivs.model.RecordingConfigurationState
  ): zio.aws.ivs.model.RecordingConfigurationState = value match {
    case software.amazon.awssdk.services.ivs.model.RecordingConfigurationState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ivs.model.RecordingConfigurationState.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.ivs.model.RecordingConfigurationState.CREATE_FAILED =>
      val r = CREATE_FAILED
      r
    case software.amazon.awssdk.services.ivs.model.RecordingConfigurationState.ACTIVE =>
      val r = ACTIVE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ivs.model.RecordingConfigurationState {
    override def unwrap
        : software.amazon.awssdk.services.ivs.model.RecordingConfigurationState =
      software.amazon.awssdk.services.ivs.model.RecordingConfigurationState.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATING extends zio.aws.ivs.model.RecordingConfigurationState {
    override def unwrap
        : software.amazon.awssdk.services.ivs.model.RecordingConfigurationState =
      software.amazon.awssdk.services.ivs.model.RecordingConfigurationState.CREATING
  }
  case object CREATE_FAILED
      extends zio.aws.ivs.model.RecordingConfigurationState {
    override def unwrap
        : software.amazon.awssdk.services.ivs.model.RecordingConfigurationState =
      software.amazon.awssdk.services.ivs.model.RecordingConfigurationState.CREATE_FAILED
  }
  case object ACTIVE extends zio.aws.ivs.model.RecordingConfigurationState {
    override def unwrap
        : software.amazon.awssdk.services.ivs.model.RecordingConfigurationState =
      software.amazon.awssdk.services.ivs.model.RecordingConfigurationState.ACTIVE
  }
}
