package zio.aws.ivs.model
import zio.aws.ivs.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListPlaybackKeyPairsResponse(
    keyPairs: Iterable[zio.aws.ivs.model.PlaybackKeyPairSummary],
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivs.model.ListPlaybackKeyPairsResponse = {
    import ListPlaybackKeyPairsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivs.model.ListPlaybackKeyPairsResponse
      .builder()
      .keyPairs(keyPairs.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ivs.model.ListPlaybackKeyPairsResponse.ReadOnly =
    zio.aws.ivs.model.ListPlaybackKeyPairsResponse.wrap(buildAwsValue())
}
object ListPlaybackKeyPairsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivs.model.ListPlaybackKeyPairsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivs.model.ListPlaybackKeyPairsResponse =
      zio.aws.ivs.model.ListPlaybackKeyPairsResponse(
        keyPairs.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def keyPairs: List[zio.aws.ivs.model.PlaybackKeyPairSummary.ReadOnly]
    def nextToken: Optional[PaginationToken]
    def getKeyPairs: ZIO[Any, Nothing, List[
      zio.aws.ivs.model.PlaybackKeyPairSummary.ReadOnly
    ]] = ZIO.succeed(keyPairs)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivs.model.ListPlaybackKeyPairsResponse
  ) extends zio.aws.ivs.model.ListPlaybackKeyPairsResponse.ReadOnly {
    override val keyPairs
        : List[zio.aws.ivs.model.PlaybackKeyPairSummary.ReadOnly] = impl
      .keyPairs()
      .asScala
      .map { item =>
        zio.aws.ivs.model.PlaybackKeyPairSummary.wrap(item)
      }
      .toList
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ivs.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivs.model.ListPlaybackKeyPairsResponse
  ): zio.aws.ivs.model.ListPlaybackKeyPairsResponse.ReadOnly = new Wrapper(impl)
}
