package zio.aws.ivs.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ivs.model.primitives.{
  TagValue,
  TagKey,
  RecordingReconnectWindowSeconds,
  RecordingConfigurationName
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class CreateRecordingConfigurationRequest(
    destinationConfiguration: zio.aws.ivs.model.DestinationConfiguration,
    name: Optional[RecordingConfigurationName] = Optional.Absent,
    recordingReconnectWindowSeconds: Optional[RecordingReconnectWindowSeconds] =
      Optional.Absent,
    renditionConfiguration: Optional[zio.aws.ivs.model.RenditionConfiguration] =
      Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    thumbnailConfiguration: Optional[zio.aws.ivs.model.ThumbnailConfiguration] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivs.model.CreateRecordingConfigurationRequest = {
    import CreateRecordingConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivs.model.CreateRecordingConfigurationRequest
      .builder()
      .destinationConfiguration(destinationConfiguration.buildAwsValue())
      .optionallyWith(
        name.map(value =>
          RecordingConfigurationName.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(
        recordingReconnectWindowSeconds.map(value =>
          RecordingReconnectWindowSeconds.unwrap(value): Integer
        )
      )(_.recordingReconnectWindowSeconds)
      .optionallyWith(
        renditionConfiguration.map(value => value.buildAwsValue())
      )(_.renditionConfiguration)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        thumbnailConfiguration.map(value => value.buildAwsValue())
      )(_.thumbnailConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.ivs.model.CreateRecordingConfigurationRequest.ReadOnly =
    zio.aws.ivs.model.CreateRecordingConfigurationRequest.wrap(buildAwsValue())
}
object CreateRecordingConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivs.model.CreateRecordingConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivs.model.CreateRecordingConfigurationRequest =
      zio.aws.ivs.model.CreateRecordingConfigurationRequest(
        destinationConfiguration.asEditable,
        name.map(value => value),
        recordingReconnectWindowSeconds.map(value => value),
        renditionConfiguration.map(value => value.asEditable),
        tags.map(value => value),
        thumbnailConfiguration.map(value => value.asEditable)
      )
    def destinationConfiguration
        : zio.aws.ivs.model.DestinationConfiguration.ReadOnly
    def name: Optional[RecordingConfigurationName]
    def recordingReconnectWindowSeconds
        : Optional[RecordingReconnectWindowSeconds]
    def renditionConfiguration
        : Optional[zio.aws.ivs.model.RenditionConfiguration.ReadOnly]
    def tags: Optional[Map[TagKey, TagValue]]
    def thumbnailConfiguration
        : Optional[zio.aws.ivs.model.ThumbnailConfiguration.ReadOnly]
    def getDestinationConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.ivs.model.DestinationConfiguration.ReadOnly
    ] = ZIO.succeed(destinationConfiguration)
    def getName: ZIO[Any, AwsError, RecordingConfigurationName] =
      AwsError.unwrapOptionField("name", name)
    def getRecordingReconnectWindowSeconds
        : ZIO[Any, AwsError, RecordingReconnectWindowSeconds] =
      AwsError.unwrapOptionField(
        "recordingReconnectWindowSeconds",
        recordingReconnectWindowSeconds
      )
    def getRenditionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.ivs.model.RenditionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "renditionConfiguration",
      renditionConfiguration
    )
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getThumbnailConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.ivs.model.ThumbnailConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "thumbnailConfiguration",
      thumbnailConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivs.model.CreateRecordingConfigurationRequest
  ) extends zio.aws.ivs.model.CreateRecordingConfigurationRequest.ReadOnly {
    override val destinationConfiguration
        : zio.aws.ivs.model.DestinationConfiguration.ReadOnly =
      zio.aws.ivs.model.DestinationConfiguration
        .wrap(impl.destinationConfiguration())
    override val name: Optional[RecordingConfigurationName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value =>
          zio.aws.ivs.model.primitives.RecordingConfigurationName(value)
        )
    override val recordingReconnectWindowSeconds
        : Optional[RecordingReconnectWindowSeconds] = zio.aws.core.internal
      .optionalFromNullable(impl.recordingReconnectWindowSeconds())
      .map(value =>
        zio.aws.ivs.model.primitives.RecordingReconnectWindowSeconds(value)
      )
    override val renditionConfiguration
        : Optional[zio.aws.ivs.model.RenditionConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.renditionConfiguration())
        .map(value => zio.aws.ivs.model.RenditionConfiguration.wrap(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.ivs.model.primitives
              .TagKey(key) -> zio.aws.ivs.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val thumbnailConfiguration
        : Optional[zio.aws.ivs.model.ThumbnailConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.thumbnailConfiguration())
        .map(value => zio.aws.ivs.model.ThumbnailConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivs.model.CreateRecordingConfigurationRequest
  ): zio.aws.ivs.model.CreateRecordingConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
