package zio.aws.ivs.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BatchStartViewerSessionRevocationRequest(
    viewerSessions: Iterable[
      zio.aws.ivs.model.BatchStartViewerSessionRevocationViewerSession
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivs.model.BatchStartViewerSessionRevocationRequest = {
    import BatchStartViewerSessionRevocationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivs.model.BatchStartViewerSessionRevocationRequest
      .builder()
      .viewerSessions(viewerSessions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.ivs.model.BatchStartViewerSessionRevocationRequest.ReadOnly =
    zio.aws.ivs.model.BatchStartViewerSessionRevocationRequest
      .wrap(buildAwsValue())
}
object BatchStartViewerSessionRevocationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivs.model.BatchStartViewerSessionRevocationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivs.model.BatchStartViewerSessionRevocationRequest =
      zio.aws.ivs.model
        .BatchStartViewerSessionRevocationRequest(viewerSessions.map { item =>
          item.asEditable
        })
    def viewerSessions: List[
      zio.aws.ivs.model.BatchStartViewerSessionRevocationViewerSession.ReadOnly
    ]
    def getViewerSessions: ZIO[Any, Nothing, List[
      zio.aws.ivs.model.BatchStartViewerSessionRevocationViewerSession.ReadOnly
    ]] = ZIO.succeed(viewerSessions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivs.model.BatchStartViewerSessionRevocationRequest
  ) extends zio.aws.ivs.model.BatchStartViewerSessionRevocationRequest.ReadOnly {
    override val viewerSessions: List[
      zio.aws.ivs.model.BatchStartViewerSessionRevocationViewerSession.ReadOnly
    ] = impl
      .viewerSessions()
      .asScala
      .map { item =>
        zio.aws.ivs.model.BatchStartViewerSessionRevocationViewerSession
          .wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivs.model.BatchStartViewerSessionRevocationRequest
  ): zio.aws.ivs.model.BatchStartViewerSessionRevocationRequest.ReadOnly =
    new Wrapper(impl)
}
