package zio.aws.ivs
import zio.aws.ivs.model.CreateRecordingConfigurationResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.ivs.model.{
  StopStreamRequest,
  GetChannelRequest,
  ImportPlaybackKeyPairResponse,
  BatchGetChannelResponse,
  ListPlaybackKeyPairsResponse,
  ListPlaybackKeyPairsRequest,
  CreateChannelResponse,
  ListStreamsRequest,
  GetStreamSessionRequest,
  ListRecordingConfigurationsResponse,
  StartViewerSessionRevocationRequest,
  UpdateChannelResponse,
  ListChannelsResponse,
  DeleteStreamKeyRequest,
  GetChannelResponse,
  DeleteChannelRequest,
  CreateChannelRequest,
  ImportPlaybackKeyPairRequest,
  ListStreamKeysResponse,
  BatchGetStreamKeyRequest,
  DeleteStreamKeyResponse,
  ListTagsForResourceRequest,
  GetStreamRequest,
  PutMetadataRequest,
  GetStreamResponse,
  ListStreamSessionsResponse,
  BatchGetStreamKeyResponse,
  DeleteRecordingConfigurationRequest,
  GetPlaybackKeyPairRequest,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  DeletePlaybackKeyPairResponse,
  GetRecordingConfigurationResponse,
  BatchGetChannelRequest,
  PutMetadataResponse,
  BatchStartViewerSessionRevocationResponse,
  ListStreamSessionsRequest,
  UpdateChannelRequest,
  CreateRecordingConfigurationResponse,
  CreateStreamKeyResponse,
  BatchStartViewerSessionRevocationRequest,
  GetStreamKeyRequest,
  StartViewerSessionRevocationResponse,
  DeletePlaybackKeyPairRequest,
  GetPlaybackKeyPairResponse,
  StopStreamResponse,
  ListChannelsRequest,
  UntagResourceRequest,
  CreateStreamKeyRequest,
  ListStreamsResponse,
  ListRecordingConfigurationsRequest,
  GetStreamSessionResponse,
  CreateRecordingConfigurationRequest,
  TagResourceResponse,
  ListStreamKeysRequest,
  DeleteChannelResponse,
  GetStreamKeyResponse,
  TagResourceRequest,
  GetRecordingConfigurationRequest,
  DeleteRecordingConfigurationResponse
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import software.amazon.awssdk.services.ivs.{
  IvsAsyncClientBuilder,
  IvsAsyncClient
}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import scala.jdk.CollectionConverters._
trait Ivs extends AspectSupport[Ivs] {
  val api: IvsAsyncClient
  def listStreams(
      request: zio.aws.ivs.model.ListStreamsRequest
  ): IO[AwsError, zio.aws.ivs.model.ListStreamsResponse.ReadOnly]
  def listChannels(
      request: zio.aws.ivs.model.ListChannelsRequest
  ): IO[AwsError, zio.aws.ivs.model.ListChannelsResponse.ReadOnly]
  def deletePlaybackKeyPair(
      request: zio.aws.ivs.model.DeletePlaybackKeyPairRequest
  ): IO[AwsError, zio.aws.ivs.model.DeletePlaybackKeyPairResponse.ReadOnly]
  def listRecordingConfigurations(
      request: zio.aws.ivs.model.ListRecordingConfigurationsRequest
  ): IO[
    AwsError,
    zio.aws.ivs.model.ListRecordingConfigurationsResponse.ReadOnly
  ]
  def listStreamKeys(
      request: zio.aws.ivs.model.ListStreamKeysRequest
  ): IO[AwsError, zio.aws.ivs.model.ListStreamKeysResponse.ReadOnly]
  def batchGetChannel(
      request: zio.aws.ivs.model.BatchGetChannelRequest
  ): IO[AwsError, zio.aws.ivs.model.BatchGetChannelResponse.ReadOnly]
  def getPlaybackKeyPair(
      request: zio.aws.ivs.model.GetPlaybackKeyPairRequest
  ): IO[AwsError, zio.aws.ivs.model.GetPlaybackKeyPairResponse.ReadOnly]
  def getStreamSession(
      request: zio.aws.ivs.model.GetStreamSessionRequest
  ): IO[AwsError, zio.aws.ivs.model.GetStreamSessionResponse.ReadOnly]
  def importPlaybackKeyPair(
      request: zio.aws.ivs.model.ImportPlaybackKeyPairRequest
  ): IO[AwsError, zio.aws.ivs.model.ImportPlaybackKeyPairResponse.ReadOnly]
  def getRecordingConfiguration(
      request: zio.aws.ivs.model.GetRecordingConfigurationRequest
  ): IO[AwsError, zio.aws.ivs.model.GetRecordingConfigurationResponse.ReadOnly]
  def putMetadata(
      request: zio.aws.ivs.model.PutMetadataRequest
  ): IO[AwsError, Unit]
  def createRecordingConfiguration(
      request: zio.aws.ivs.model.CreateRecordingConfigurationRequest
  ): IO[AwsError, ReadOnly]
  def deleteChannel(
      request: zio.aws.ivs.model.DeleteChannelRequest
  ): IO[AwsError, Unit]
  def stopStream(
      request: zio.aws.ivs.model.StopStreamRequest
  ): IO[AwsError, zio.aws.ivs.model.StopStreamResponse.ReadOnly]
  def batchGetStreamKey(
      request: zio.aws.ivs.model.BatchGetStreamKeyRequest
  ): IO[AwsError, zio.aws.ivs.model.BatchGetStreamKeyResponse.ReadOnly]
  def createChannel(
      request: zio.aws.ivs.model.CreateChannelRequest
  ): IO[AwsError, zio.aws.ivs.model.CreateChannelResponse.ReadOnly]
  def untagResource(
      request: zio.aws.ivs.model.UntagResourceRequest
  ): IO[AwsError, zio.aws.ivs.model.UntagResourceResponse.ReadOnly]
  def startViewerSessionRevocation(
      request: zio.aws.ivs.model.StartViewerSessionRevocationRequest
  ): IO[
    AwsError,
    zio.aws.ivs.model.StartViewerSessionRevocationResponse.ReadOnly
  ]
  def deleteRecordingConfiguration(
      request: zio.aws.ivs.model.DeleteRecordingConfigurationRequest
  ): IO[AwsError, Unit]
  def listStreamSessions(
      request: zio.aws.ivs.model.ListStreamSessionsRequest
  ): IO[AwsError, zio.aws.ivs.model.ListStreamSessionsResponse.ReadOnly]
  def getChannel(
      request: zio.aws.ivs.model.GetChannelRequest
  ): IO[AwsError, zio.aws.ivs.model.GetChannelResponse.ReadOnly]
  def listTagsForResource(
      request: zio.aws.ivs.model.ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.ivs.model.ListTagsForResourceResponse.ReadOnly]
  def tagResource(
      request: zio.aws.ivs.model.TagResourceRequest
  ): IO[AwsError, zio.aws.ivs.model.TagResourceResponse.ReadOnly]
  def createStreamKey(
      request: zio.aws.ivs.model.CreateStreamKeyRequest
  ): IO[AwsError, zio.aws.ivs.model.CreateStreamKeyResponse.ReadOnly]
  def listPlaybackKeyPairs(
      request: zio.aws.ivs.model.ListPlaybackKeyPairsRequest
  ): IO[AwsError, zio.aws.ivs.model.ListPlaybackKeyPairsResponse.ReadOnly]
  def getStreamKey(
      request: zio.aws.ivs.model.GetStreamKeyRequest
  ): IO[AwsError, zio.aws.ivs.model.GetStreamKeyResponse.ReadOnly]
  def getStream(
      request: zio.aws.ivs.model.GetStreamRequest
  ): IO[AwsError, zio.aws.ivs.model.GetStreamResponse.ReadOnly]
  def deleteStreamKey(
      request: zio.aws.ivs.model.DeleteStreamKeyRequest
  ): IO[AwsError, Unit]
  def batchStartViewerSessionRevocation(
      request: zio.aws.ivs.model.BatchStartViewerSessionRevocationRequest
  ): IO[
    AwsError,
    zio.aws.ivs.model.BatchStartViewerSessionRevocationResponse.ReadOnly
  ]
  def updateChannel(
      request: zio.aws.ivs.model.UpdateChannelRequest
  ): IO[AwsError, zio.aws.ivs.model.UpdateChannelResponse.ReadOnly]
}
object Ivs {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Ivs] = customized(identity)
  def customized(
      customization: IvsAsyncClientBuilder => IvsAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Ivs] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: IvsAsyncClientBuilder => IvsAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, Ivs] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = IvsAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[IvsAsyncClient, IvsAsyncClientBuilder](builder);
    b1 <- awsConfig.configureHttpClient[IvsAsyncClient, IvsAsyncClientBuilder](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  ) yield new IvsImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class IvsImpl[R](
      override val api: IvsAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Ivs
      with AwsServiceBase[R] {
    override val serviceName: String = "Ivs"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): IvsImpl[R1] = new IvsImpl(api, newAspect, r)
    def listStreams(
        request: zio.aws.ivs.model.ListStreamsRequest
    ): IO[AwsError, zio.aws.ivs.model.ListStreamsResponse.ReadOnly] =
      asyncRequestResponse[ListStreamsRequest, ListStreamsResponse](
        "listStreams",
        api.listStreams
      )(request.buildAwsValue())
        .map(zio.aws.ivs.model.ListStreamsResponse.wrap)
        .provideEnvironment(r)
    def listChannels(
        request: zio.aws.ivs.model.ListChannelsRequest
    ): IO[AwsError, zio.aws.ivs.model.ListChannelsResponse.ReadOnly] =
      asyncRequestResponse[ListChannelsRequest, ListChannelsResponse](
        "listChannels",
        api.listChannels
      )(request.buildAwsValue())
        .map(zio.aws.ivs.model.ListChannelsResponse.wrap)
        .provideEnvironment(r)
    def deletePlaybackKeyPair(
        request: zio.aws.ivs.model.DeletePlaybackKeyPairRequest
    ): IO[AwsError, zio.aws.ivs.model.DeletePlaybackKeyPairResponse.ReadOnly] =
      asyncRequestResponse[
        DeletePlaybackKeyPairRequest,
        DeletePlaybackKeyPairResponse
      ]("deletePlaybackKeyPair", api.deletePlaybackKeyPair)(
        request.buildAwsValue()
      ).map(zio.aws.ivs.model.DeletePlaybackKeyPairResponse.wrap)
        .provideEnvironment(r)
    def listRecordingConfigurations(
        request: zio.aws.ivs.model.ListRecordingConfigurationsRequest
    ): IO[
      AwsError,
      zio.aws.ivs.model.ListRecordingConfigurationsResponse.ReadOnly
    ] = asyncRequestResponse[
      ListRecordingConfigurationsRequest,
      ListRecordingConfigurationsResponse
    ]("listRecordingConfigurations", api.listRecordingConfigurations)(
      request.buildAwsValue()
    ).map(zio.aws.ivs.model.ListRecordingConfigurationsResponse.wrap)
      .provideEnvironment(r)
    def listStreamKeys(
        request: zio.aws.ivs.model.ListStreamKeysRequest
    ): IO[AwsError, zio.aws.ivs.model.ListStreamKeysResponse.ReadOnly] =
      asyncRequestResponse[ListStreamKeysRequest, ListStreamKeysResponse](
        "listStreamKeys",
        api.listStreamKeys
      )(request.buildAwsValue())
        .map(zio.aws.ivs.model.ListStreamKeysResponse.wrap)
        .provideEnvironment(r)
    def batchGetChannel(
        request: zio.aws.ivs.model.BatchGetChannelRequest
    ): IO[AwsError, zio.aws.ivs.model.BatchGetChannelResponse.ReadOnly] =
      asyncRequestResponse[BatchGetChannelRequest, BatchGetChannelResponse](
        "batchGetChannel",
        api.batchGetChannel
      )(request.buildAwsValue())
        .map(zio.aws.ivs.model.BatchGetChannelResponse.wrap)
        .provideEnvironment(r)
    def getPlaybackKeyPair(
        request: zio.aws.ivs.model.GetPlaybackKeyPairRequest
    ): IO[AwsError, zio.aws.ivs.model.GetPlaybackKeyPairResponse.ReadOnly] =
      asyncRequestResponse[
        GetPlaybackKeyPairRequest,
        GetPlaybackKeyPairResponse
      ]("getPlaybackKeyPair", api.getPlaybackKeyPair)(request.buildAwsValue())
        .map(zio.aws.ivs.model.GetPlaybackKeyPairResponse.wrap)
        .provideEnvironment(r)
    def getStreamSession(
        request: zio.aws.ivs.model.GetStreamSessionRequest
    ): IO[AwsError, zio.aws.ivs.model.GetStreamSessionResponse.ReadOnly] =
      asyncRequestResponse[GetStreamSessionRequest, GetStreamSessionResponse](
        "getStreamSession",
        api.getStreamSession
      )(request.buildAwsValue())
        .map(zio.aws.ivs.model.GetStreamSessionResponse.wrap)
        .provideEnvironment(r)
    def importPlaybackKeyPair(
        request: zio.aws.ivs.model.ImportPlaybackKeyPairRequest
    ): IO[AwsError, zio.aws.ivs.model.ImportPlaybackKeyPairResponse.ReadOnly] =
      asyncRequestResponse[
        ImportPlaybackKeyPairRequest,
        ImportPlaybackKeyPairResponse
      ]("importPlaybackKeyPair", api.importPlaybackKeyPair)(
        request.buildAwsValue()
      ).map(zio.aws.ivs.model.ImportPlaybackKeyPairResponse.wrap)
        .provideEnvironment(r)
    def getRecordingConfiguration(
        request: zio.aws.ivs.model.GetRecordingConfigurationRequest
    ): IO[
      AwsError,
      zio.aws.ivs.model.GetRecordingConfigurationResponse.ReadOnly
    ] = asyncRequestResponse[
      GetRecordingConfigurationRequest,
      GetRecordingConfigurationResponse
    ]("getRecordingConfiguration", api.getRecordingConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.ivs.model.GetRecordingConfigurationResponse.wrap)
      .provideEnvironment(r)
    def putMetadata(
        request: zio.aws.ivs.model.PutMetadataRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[PutMetadataRequest, PutMetadataResponse](
        "putMetadata",
        api.putMetadata
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def createRecordingConfiguration(
        request: zio.aws.ivs.model.CreateRecordingConfigurationRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      CreateRecordingConfigurationRequest,
      CreateRecordingConfigurationResponse
    ]("createRecordingConfiguration", api.createRecordingConfiguration)(
      request.buildAwsValue()
    ).map(zio.aws.ivs.model.CreateRecordingConfigurationResponse.wrap)
      .provideEnvironment(r)
    def deleteChannel(
        request: zio.aws.ivs.model.DeleteChannelRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteChannelRequest, DeleteChannelResponse](
        "deleteChannel",
        api.deleteChannel
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def stopStream(
        request: zio.aws.ivs.model.StopStreamRequest
    ): IO[AwsError, zio.aws.ivs.model.StopStreamResponse.ReadOnly] =
      asyncRequestResponse[StopStreamRequest, StopStreamResponse](
        "stopStream",
        api.stopStream
      )(request.buildAwsValue())
        .map(zio.aws.ivs.model.StopStreamResponse.wrap)
        .provideEnvironment(r)
    def batchGetStreamKey(
        request: zio.aws.ivs.model.BatchGetStreamKeyRequest
    ): IO[AwsError, zio.aws.ivs.model.BatchGetStreamKeyResponse.ReadOnly] =
      asyncRequestResponse[BatchGetStreamKeyRequest, BatchGetStreamKeyResponse](
        "batchGetStreamKey",
        api.batchGetStreamKey
      )(request.buildAwsValue())
        .map(zio.aws.ivs.model.BatchGetStreamKeyResponse.wrap)
        .provideEnvironment(r)
    def createChannel(
        request: zio.aws.ivs.model.CreateChannelRequest
    ): IO[AwsError, zio.aws.ivs.model.CreateChannelResponse.ReadOnly] =
      asyncRequestResponse[CreateChannelRequest, CreateChannelResponse](
        "createChannel",
        api.createChannel
      )(request.buildAwsValue())
        .map(zio.aws.ivs.model.CreateChannelResponse.wrap)
        .provideEnvironment(r)
    def untagResource(
        request: zio.aws.ivs.model.UntagResourceRequest
    ): IO[AwsError, zio.aws.ivs.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[UntagResourceRequest, UntagResourceResponse](
        "untagResource",
        api.untagResource
      )(request.buildAwsValue())
        .map(zio.aws.ivs.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def startViewerSessionRevocation(
        request: zio.aws.ivs.model.StartViewerSessionRevocationRequest
    ): IO[
      AwsError,
      zio.aws.ivs.model.StartViewerSessionRevocationResponse.ReadOnly
    ] = asyncRequestResponse[
      StartViewerSessionRevocationRequest,
      StartViewerSessionRevocationResponse
    ]("startViewerSessionRevocation", api.startViewerSessionRevocation)(
      request.buildAwsValue()
    ).map(zio.aws.ivs.model.StartViewerSessionRevocationResponse.wrap)
      .provideEnvironment(r)
    def deleteRecordingConfiguration(
        request: zio.aws.ivs.model.DeleteRecordingConfigurationRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      DeleteRecordingConfigurationRequest,
      DeleteRecordingConfigurationResponse
    ]("deleteRecordingConfiguration", api.deleteRecordingConfiguration)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def listStreamSessions(
        request: zio.aws.ivs.model.ListStreamSessionsRequest
    ): IO[AwsError, zio.aws.ivs.model.ListStreamSessionsResponse.ReadOnly] =
      asyncRequestResponse[
        ListStreamSessionsRequest,
        ListStreamSessionsResponse
      ]("listStreamSessions", api.listStreamSessions)(request.buildAwsValue())
        .map(zio.aws.ivs.model.ListStreamSessionsResponse.wrap)
        .provideEnvironment(r)
    def getChannel(
        request: zio.aws.ivs.model.GetChannelRequest
    ): IO[AwsError, zio.aws.ivs.model.GetChannelResponse.ReadOnly] =
      asyncRequestResponse[GetChannelRequest, GetChannelResponse](
        "getChannel",
        api.getChannel
      )(request.buildAwsValue())
        .map(zio.aws.ivs.model.GetChannelResponse.wrap)
        .provideEnvironment(r)
    def listTagsForResource(
        request: zio.aws.ivs.model.ListTagsForResourceRequest
    ): IO[AwsError, zio.aws.ivs.model.ListTagsForResourceResponse.ReadOnly] =
      asyncRequestResponse[
        ListTagsForResourceRequest,
        ListTagsForResourceResponse
      ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
        .map(zio.aws.ivs.model.ListTagsForResourceResponse.wrap)
        .provideEnvironment(r)
    def tagResource(
        request: zio.aws.ivs.model.TagResourceRequest
    ): IO[AwsError, zio.aws.ivs.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[TagResourceRequest, TagResourceResponse](
        "tagResource",
        api.tagResource
      )(request.buildAwsValue())
        .map(zio.aws.ivs.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def createStreamKey(
        request: zio.aws.ivs.model.CreateStreamKeyRequest
    ): IO[AwsError, zio.aws.ivs.model.CreateStreamKeyResponse.ReadOnly] =
      asyncRequestResponse[CreateStreamKeyRequest, CreateStreamKeyResponse](
        "createStreamKey",
        api.createStreamKey
      )(request.buildAwsValue())
        .map(zio.aws.ivs.model.CreateStreamKeyResponse.wrap)
        .provideEnvironment(r)
    def listPlaybackKeyPairs(
        request: zio.aws.ivs.model.ListPlaybackKeyPairsRequest
    ): IO[AwsError, zio.aws.ivs.model.ListPlaybackKeyPairsResponse.ReadOnly] =
      asyncRequestResponse[
        ListPlaybackKeyPairsRequest,
        ListPlaybackKeyPairsResponse
      ]("listPlaybackKeyPairs", api.listPlaybackKeyPairs)(
        request.buildAwsValue()
      ).map(zio.aws.ivs.model.ListPlaybackKeyPairsResponse.wrap)
        .provideEnvironment(r)
    def getStreamKey(
        request: zio.aws.ivs.model.GetStreamKeyRequest
    ): IO[AwsError, zio.aws.ivs.model.GetStreamKeyResponse.ReadOnly] =
      asyncRequestResponse[GetStreamKeyRequest, GetStreamKeyResponse](
        "getStreamKey",
        api.getStreamKey
      )(request.buildAwsValue())
        .map(zio.aws.ivs.model.GetStreamKeyResponse.wrap)
        .provideEnvironment(r)
    def getStream(
        request: zio.aws.ivs.model.GetStreamRequest
    ): IO[AwsError, zio.aws.ivs.model.GetStreamResponse.ReadOnly] =
      asyncRequestResponse[GetStreamRequest, GetStreamResponse](
        "getStream",
        api.getStream
      )(request.buildAwsValue())
        .map(zio.aws.ivs.model.GetStreamResponse.wrap)
        .provideEnvironment(r)
    def deleteStreamKey(
        request: zio.aws.ivs.model.DeleteStreamKeyRequest
    ): IO[AwsError, Unit] =
      asyncRequestResponse[DeleteStreamKeyRequest, DeleteStreamKeyResponse](
        "deleteStreamKey",
        api.deleteStreamKey
      )(request.buildAwsValue()).unit.provideEnvironment(r)
    def batchStartViewerSessionRevocation(
        request: zio.aws.ivs.model.BatchStartViewerSessionRevocationRequest
    ): IO[
      AwsError,
      zio.aws.ivs.model.BatchStartViewerSessionRevocationResponse.ReadOnly
    ] = asyncRequestResponse[
      BatchStartViewerSessionRevocationRequest,
      BatchStartViewerSessionRevocationResponse
    ](
      "batchStartViewerSessionRevocation",
      api.batchStartViewerSessionRevocation
    )(request.buildAwsValue())
      .map(zio.aws.ivs.model.BatchStartViewerSessionRevocationResponse.wrap)
      .provideEnvironment(r)
    def updateChannel(
        request: zio.aws.ivs.model.UpdateChannelRequest
    ): IO[AwsError, zio.aws.ivs.model.UpdateChannelResponse.ReadOnly] =
      asyncRequestResponse[UpdateChannelRequest, UpdateChannelResponse](
        "updateChannel",
        api.updateChannel
      )(request.buildAwsValue())
        .map(zio.aws.ivs.model.UpdateChannelResponse.wrap)
        .provideEnvironment(r)
  }
  def listStreams(request: zio.aws.ivs.model.ListStreamsRequest): ZIO[
    zio.aws.ivs.Ivs,
    AwsError,
    zio.aws.ivs.model.ListStreamsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listStreams(request))
  def listChannels(request: zio.aws.ivs.model.ListChannelsRequest): ZIO[
    zio.aws.ivs.Ivs,
    AwsError,
    zio.aws.ivs.model.ListChannelsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listChannels(request))
  def deletePlaybackKeyPair(
      request: zio.aws.ivs.model.DeletePlaybackKeyPairRequest
  ): ZIO[
    zio.aws.ivs.Ivs,
    AwsError,
    zio.aws.ivs.model.DeletePlaybackKeyPairResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deletePlaybackKeyPair(request))
  def listRecordingConfigurations(
      request: zio.aws.ivs.model.ListRecordingConfigurationsRequest
  ): ZIO[
    zio.aws.ivs.Ivs,
    AwsError,
    zio.aws.ivs.model.ListRecordingConfigurationsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listRecordingConfigurations(request))
  def listStreamKeys(request: zio.aws.ivs.model.ListStreamKeysRequest): ZIO[
    zio.aws.ivs.Ivs,
    AwsError,
    zio.aws.ivs.model.ListStreamKeysResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listStreamKeys(request))
  def batchGetChannel(request: zio.aws.ivs.model.BatchGetChannelRequest): ZIO[
    zio.aws.ivs.Ivs,
    AwsError,
    zio.aws.ivs.model.BatchGetChannelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchGetChannel(request))
  def getPlaybackKeyPair(
      request: zio.aws.ivs.model.GetPlaybackKeyPairRequest
  ): ZIO[
    zio.aws.ivs.Ivs,
    AwsError,
    zio.aws.ivs.model.GetPlaybackKeyPairResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getPlaybackKeyPair(request))
  def getStreamSession(request: zio.aws.ivs.model.GetStreamSessionRequest): ZIO[
    zio.aws.ivs.Ivs,
    AwsError,
    zio.aws.ivs.model.GetStreamSessionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getStreamSession(request))
  def importPlaybackKeyPair(
      request: zio.aws.ivs.model.ImportPlaybackKeyPairRequest
  ): ZIO[
    zio.aws.ivs.Ivs,
    AwsError,
    zio.aws.ivs.model.ImportPlaybackKeyPairResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.importPlaybackKeyPair(request))
  def getRecordingConfiguration(
      request: zio.aws.ivs.model.GetRecordingConfigurationRequest
  ): ZIO[
    zio.aws.ivs.Ivs,
    AwsError,
    zio.aws.ivs.model.GetRecordingConfigurationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getRecordingConfiguration(request))
  def putMetadata(
      request: zio.aws.ivs.model.PutMetadataRequest
  ): ZIO[zio.aws.ivs.Ivs, AwsError, Unit] =
    ZIO.serviceWithZIO(_.putMetadata(request))
  def createRecordingConfiguration(
      request: zio.aws.ivs.model.CreateRecordingConfigurationRequest
  ): ZIO[zio.aws.ivs.Ivs, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.createRecordingConfiguration(request))
  def deleteChannel(
      request: zio.aws.ivs.model.DeleteChannelRequest
  ): ZIO[zio.aws.ivs.Ivs, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteChannel(request))
  def stopStream(request: zio.aws.ivs.model.StopStreamRequest): ZIO[
    zio.aws.ivs.Ivs,
    AwsError,
    zio.aws.ivs.model.StopStreamResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopStream(request))
  def batchGetStreamKey(
      request: zio.aws.ivs.model.BatchGetStreamKeyRequest
  ): ZIO[
    zio.aws.ivs.Ivs,
    AwsError,
    zio.aws.ivs.model.BatchGetStreamKeyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchGetStreamKey(request))
  def createChannel(request: zio.aws.ivs.model.CreateChannelRequest): ZIO[
    zio.aws.ivs.Ivs,
    AwsError,
    zio.aws.ivs.model.CreateChannelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createChannel(request))
  def untagResource(request: zio.aws.ivs.model.UntagResourceRequest): ZIO[
    zio.aws.ivs.Ivs,
    AwsError,
    zio.aws.ivs.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def startViewerSessionRevocation(
      request: zio.aws.ivs.model.StartViewerSessionRevocationRequest
  ): ZIO[
    zio.aws.ivs.Ivs,
    AwsError,
    zio.aws.ivs.model.StartViewerSessionRevocationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startViewerSessionRevocation(request))
  def deleteRecordingConfiguration(
      request: zio.aws.ivs.model.DeleteRecordingConfigurationRequest
  ): ZIO[zio.aws.ivs.Ivs, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteRecordingConfiguration(request))
  def listStreamSessions(
      request: zio.aws.ivs.model.ListStreamSessionsRequest
  ): ZIO[
    zio.aws.ivs.Ivs,
    AwsError,
    zio.aws.ivs.model.ListStreamSessionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listStreamSessions(request))
  def getChannel(request: zio.aws.ivs.model.GetChannelRequest): ZIO[
    zio.aws.ivs.Ivs,
    AwsError,
    zio.aws.ivs.model.GetChannelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getChannel(request))
  def listTagsForResource(
      request: zio.aws.ivs.model.ListTagsForResourceRequest
  ): ZIO[
    zio.aws.ivs.Ivs,
    AwsError,
    zio.aws.ivs.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def tagResource(request: zio.aws.ivs.model.TagResourceRequest): ZIO[
    zio.aws.ivs.Ivs,
    AwsError,
    zio.aws.ivs.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def createStreamKey(request: zio.aws.ivs.model.CreateStreamKeyRequest): ZIO[
    zio.aws.ivs.Ivs,
    AwsError,
    zio.aws.ivs.model.CreateStreamKeyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createStreamKey(request))
  def listPlaybackKeyPairs(
      request: zio.aws.ivs.model.ListPlaybackKeyPairsRequest
  ): ZIO[
    zio.aws.ivs.Ivs,
    AwsError,
    zio.aws.ivs.model.ListPlaybackKeyPairsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listPlaybackKeyPairs(request))
  def getStreamKey(request: zio.aws.ivs.model.GetStreamKeyRequest): ZIO[
    zio.aws.ivs.Ivs,
    AwsError,
    zio.aws.ivs.model.GetStreamKeyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getStreamKey(request))
  def getStream(request: zio.aws.ivs.model.GetStreamRequest): ZIO[
    zio.aws.ivs.Ivs,
    AwsError,
    zio.aws.ivs.model.GetStreamResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getStream(request))
  def deleteStreamKey(
      request: zio.aws.ivs.model.DeleteStreamKeyRequest
  ): ZIO[zio.aws.ivs.Ivs, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteStreamKey(request))
  def batchStartViewerSessionRevocation(
      request: zio.aws.ivs.model.BatchStartViewerSessionRevocationRequest
  ): ZIO[
    zio.aws.ivs.Ivs,
    AwsError,
    zio.aws.ivs.model.BatchStartViewerSessionRevocationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.batchStartViewerSessionRevocation(request))
  def updateChannel(request: zio.aws.ivs.model.UpdateChannelRequest): ZIO[
    zio.aws.ivs.Ivs,
    AwsError,
    zio.aws.ivs.model.UpdateChannelResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateChannel(request))
}
