package zio.aws.ivs
import zio.prelude.Subtype
import zio.aws.ivs.model.primitives.{TagValue, TagKey, StreamKeyArn, ChannelArn}
import java.time.Instant
import zio.aws.ivs.model.primitives.StreamId.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object ChannelArn extends Subtype[String]
    type ChannelArn = zio.aws.ivs.model.primitives.ChannelArn.Type
    object ChannelName extends Subtype[String]
    type ChannelName = zio.aws.ivs.model.primitives.ChannelName.Type
    object ChannelRecordingConfigurationArn extends Subtype[String]
    type ChannelRecordingConfigurationArn =
      zio.aws.ivs.model.primitives.ChannelRecordingConfigurationArn.Type
    object ErrorCode extends Subtype[String]
    type ErrorCode = zio.aws.ivs.model.primitives.ErrorCode.Type
    object ErrorMessage extends Subtype[String]
    type ErrorMessage = zio.aws.ivs.model.primitives.ErrorMessage.Type
    object IngestEndpoint extends Subtype[String]
    type IngestEndpoint = zio.aws.ivs.model.primitives.IngestEndpoint.Type
    object InsecureIngest extends Subtype[Boolean]
    type InsecureIngest = zio.aws.ivs.model.primitives.InsecureIngest.Type
    type Integer = Long
    object IsAuthorized extends Subtype[Boolean]
    type IsAuthorized = zio.aws.ivs.model.primitives.IsAuthorized.Type
    object MaxChannelResults extends Subtype[Int]
    type MaxChannelResults = zio.aws.ivs.model.primitives.MaxChannelResults.Type
    object MaxPlaybackKeyPairResults extends Subtype[Int]
    type MaxPlaybackKeyPairResults =
      zio.aws.ivs.model.primitives.MaxPlaybackKeyPairResults.Type
    object MaxRecordingConfigurationResults extends Subtype[Int]
    type MaxRecordingConfigurationResults =
      zio.aws.ivs.model.primitives.MaxRecordingConfigurationResults.Type
    object MaxStreamKeyResults extends Subtype[Int]
    type MaxStreamKeyResults =
      zio.aws.ivs.model.primitives.MaxStreamKeyResults.Type
    object MaxStreamResults extends Subtype[Int]
    type MaxStreamResults = zio.aws.ivs.model.primitives.MaxStreamResults.Type
    object PaginationToken extends Subtype[String]
    type PaginationToken = zio.aws.ivs.model.primitives.PaginationToken.Type
    object PlaybackKeyPairArn extends Subtype[String]
    type PlaybackKeyPairArn =
      zio.aws.ivs.model.primitives.PlaybackKeyPairArn.Type
    object PlaybackKeyPairFingerprint extends Subtype[String]
    type PlaybackKeyPairFingerprint =
      zio.aws.ivs.model.primitives.PlaybackKeyPairFingerprint.Type
    object PlaybackKeyPairName extends Subtype[String]
    type PlaybackKeyPairName =
      zio.aws.ivs.model.primitives.PlaybackKeyPairName.Type
    object PlaybackPublicKeyMaterial extends Subtype[String]
    type PlaybackPublicKeyMaterial =
      zio.aws.ivs.model.primitives.PlaybackPublicKeyMaterial.Type
    object PlaybackURL extends Subtype[String]
    type PlaybackURL = zio.aws.ivs.model.primitives.PlaybackURL.Type
    object RecordingConfigurationArn extends Subtype[String]
    type RecordingConfigurationArn =
      zio.aws.ivs.model.primitives.RecordingConfigurationArn.Type
    object RecordingConfigurationName extends Subtype[String]
    type RecordingConfigurationName =
      zio.aws.ivs.model.primitives.RecordingConfigurationName.Type
    object RecordingReconnectWindowSeconds extends Subtype[Int]
    type RecordingReconnectWindowSeconds =
      zio.aws.ivs.model.primitives.RecordingReconnectWindowSeconds.Type
    object ResourceArn extends Subtype[String]
    type ResourceArn = zio.aws.ivs.model.primitives.ResourceArn.Type
    object S3DestinationBucketName extends Subtype[String]
    type S3DestinationBucketName =
      zio.aws.ivs.model.primitives.S3DestinationBucketName.Type
    object StreamId extends Subtype[String]
    type StreamId = zio.aws.ivs.model.primitives.StreamId.Type
    object StreamKeyArn extends Subtype[String]
    type StreamKeyArn = zio.aws.ivs.model.primitives.StreamKeyArn.Type
    object StreamKeyValue extends Subtype[String]
    type StreamKeyValue = zio.aws.ivs.model.primitives.StreamKeyValue.Type
    object StreamMetadata extends Subtype[String]
    type StreamMetadata = zio.aws.ivs.model.primitives.StreamMetadata.Type
    object StreamStartTime extends Subtype[Instant]
    type StreamStartTime = zio.aws.ivs.model.primitives.StreamStartTime.Type
    object StreamViewerCount extends Subtype[Long]
    type StreamViewerCount = zio.aws.ivs.model.primitives.StreamViewerCount.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.ivs.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.ivs.model.primitives.TagValue.Type
    object TargetIntervalSeconds extends Subtype[Long]
    type TargetIntervalSeconds =
      zio.aws.ivs.model.primitives.TargetIntervalSeconds.Type
    object Time extends Subtype[Instant]
    type Time = zio.aws.ivs.model.primitives.Time.Type
    object ViewerId extends Subtype[String]
    type ViewerId = zio.aws.ivs.model.primitives.ViewerId.Type
    object ViewerSessionVersion extends Subtype[Int]
    type ViewerSessionVersion =
      zio.aws.ivs.model.primitives.ViewerSessionVersion.Type
  }
  type BatchErrors = List[zio.aws.ivs.model.BatchError]
  type BatchStartViewerSessionRevocationErrors =
    List[zio.aws.ivs.model.BatchStartViewerSessionRevocationError]
  type BatchStartViewerSessionRevocationViewerSessionList =
    List[zio.aws.ivs.model.BatchStartViewerSessionRevocationViewerSession]
  type ChannelArnList = List[ChannelArn]
  type ChannelList = List[zio.aws.ivs.model.ChannelSummary]
  type Channels = List[zio.aws.ivs.model.Channel]
  type PlaybackKeyPairList = List[zio.aws.ivs.model.PlaybackKeyPairSummary]
  type RecordingConfigurationList =
    List[zio.aws.ivs.model.RecordingConfigurationSummary]
  type StreamEvents = List[zio.aws.ivs.model.StreamEvent]
  type StreamKeyArnList = List[StreamKeyArn]
  type StreamKeyList = List[zio.aws.ivs.model.StreamKeySummary]
  type StreamKeys = List[zio.aws.ivs.model.StreamKey]
  type StreamList = List[zio.aws.ivs.model.StreamSummary]
  type StreamSessionList = List[zio.aws.ivs.model.StreamSessionSummary]
  type TagKeyList = List[TagKey]
  type Tags = Map[TagKey, TagValue]
}
