package zio.aws.ivs.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ivs.model.primitives.{StreamId, Time}
import scala.jdk.CollectionConverters._
final case class StreamSession(
    channel: Optional[zio.aws.ivs.model.Channel] = Optional.Absent,
    endTime: Optional[Time] = Optional.Absent,
    ingestConfiguration: Optional[zio.aws.ivs.model.IngestConfiguration] =
      Optional.Absent,
    recordingConfiguration: Optional[zio.aws.ivs.model.RecordingConfiguration] =
      Optional.Absent,
    startTime: Optional[Time] = Optional.Absent,
    streamId: Optional[StreamId] = Optional.Absent,
    truncatedEvents: Optional[Iterable[zio.aws.ivs.model.StreamEvent]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivs.model.StreamSession = {
    import StreamSession.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivs.model.StreamSession
      .builder()
      .optionallyWith(channel.map(value => value.buildAwsValue()))(_.channel)
      .optionallyWith(endTime.map(value => Time.unwrap(value): Instant))(
        _.endTime
      )
      .optionallyWith(ingestConfiguration.map(value => value.buildAwsValue()))(
        _.ingestConfiguration
      )
      .optionallyWith(
        recordingConfiguration.map(value => value.buildAwsValue())
      )(_.recordingConfiguration)
      .optionallyWith(startTime.map(value => Time.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(
        streamId.map(value => StreamId.unwrap(value): java.lang.String)
      )(_.streamId)
      .optionallyWith(
        truncatedEvents.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.truncatedEvents)
      .build()
  }
  def asReadOnly: zio.aws.ivs.model.StreamSession.ReadOnly =
    zio.aws.ivs.model.StreamSession.wrap(buildAwsValue())
}
object StreamSession {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ivs.model.StreamSession] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivs.model.StreamSession =
      zio.aws.ivs.model.StreamSession(
        channel.map(value => value.asEditable),
        endTime.map(value => value),
        ingestConfiguration.map(value => value.asEditable),
        recordingConfiguration.map(value => value.asEditable),
        startTime.map(value => value),
        streamId.map(value => value),
        truncatedEvents.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def channel: Optional[zio.aws.ivs.model.Channel.ReadOnly]
    def endTime: Optional[Time]
    def ingestConfiguration
        : Optional[zio.aws.ivs.model.IngestConfiguration.ReadOnly]
    def recordingConfiguration
        : Optional[zio.aws.ivs.model.RecordingConfiguration.ReadOnly]
    def startTime: Optional[Time]
    def streamId: Optional[StreamId]
    def truncatedEvents: Optional[List[zio.aws.ivs.model.StreamEvent.ReadOnly]]
    def getChannel: ZIO[Any, AwsError, zio.aws.ivs.model.Channel.ReadOnly] =
      AwsError.unwrapOptionField("channel", channel)
    def getEndTime: ZIO[Any, AwsError, Time] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getIngestConfiguration
        : ZIO[Any, AwsError, zio.aws.ivs.model.IngestConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("ingestConfiguration", ingestConfiguration)
    def getRecordingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.ivs.model.RecordingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "recordingConfiguration",
      recordingConfiguration
    )
    def getStartTime: ZIO[Any, AwsError, Time] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getStreamId: ZIO[Any, AwsError, StreamId] =
      AwsError.unwrapOptionField("streamId", streamId)
    def getTruncatedEvents
        : ZIO[Any, AwsError, List[zio.aws.ivs.model.StreamEvent.ReadOnly]] =
      AwsError.unwrapOptionField("truncatedEvents", truncatedEvents)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivs.model.StreamSession
  ) extends zio.aws.ivs.model.StreamSession.ReadOnly {
    override val channel: Optional[zio.aws.ivs.model.Channel.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.channel())
        .map(value => zio.aws.ivs.model.Channel.wrap(value))
    override val endTime: Optional[Time] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.ivs.model.primitives.Time(value))
    override val ingestConfiguration
        : Optional[zio.aws.ivs.model.IngestConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ingestConfiguration())
        .map(value => zio.aws.ivs.model.IngestConfiguration.wrap(value))
    override val recordingConfiguration
        : Optional[zio.aws.ivs.model.RecordingConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recordingConfiguration())
        .map(value => zio.aws.ivs.model.RecordingConfiguration.wrap(value))
    override val startTime: Optional[Time] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.ivs.model.primitives.Time(value))
    override val streamId: Optional[StreamId] = zio.aws.core.internal
      .optionalFromNullable(impl.streamId())
      .map(value => zio.aws.ivs.model.primitives.StreamId(value))
    override val truncatedEvents
        : Optional[List[zio.aws.ivs.model.StreamEvent.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.truncatedEvents())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ivs.model.StreamEvent.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivs.model.StreamSession
  ): zio.aws.ivs.model.StreamSession.ReadOnly = new Wrapper(impl)
}
