package zio.aws.ivs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class StreamFilters(
    health: Optional[zio.aws.ivs.model.StreamHealth] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivs.model.StreamFilters = {
    import StreamFilters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivs.model.StreamFilters
      .builder()
      .optionallyWith(health.map(value => value.unwrap))(_.health)
      .build()
  }
  def asReadOnly: zio.aws.ivs.model.StreamFilters.ReadOnly =
    zio.aws.ivs.model.StreamFilters.wrap(buildAwsValue())
}
object StreamFilters {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ivs.model.StreamFilters] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivs.model.StreamFilters =
      zio.aws.ivs.model.StreamFilters(health.map(value => value))
    def health: Optional[zio.aws.ivs.model.StreamHealth]
    def getHealth: ZIO[Any, AwsError, zio.aws.ivs.model.StreamHealth] =
      AwsError.unwrapOptionField("health", health)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivs.model.StreamFilters
  ) extends zio.aws.ivs.model.StreamFilters.ReadOnly {
    override val health: Optional[zio.aws.ivs.model.StreamHealth] =
      zio.aws.core.internal
        .optionalFromNullable(impl.health())
        .map(value => zio.aws.ivs.model.StreamHealth.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivs.model.StreamFilters
  ): zio.aws.ivs.model.StreamFilters.ReadOnly = new Wrapper(impl)
}
