package zio.aws.ivs.model
import zio.aws.ivs.model.primitives.{
  TagValue,
  PlaybackKeyPairFingerprint,
  PlaybackKeyPairArn,
  TagKey,
  PlaybackKeyPairName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PlaybackKeyPair(
    arn: Optional[PlaybackKeyPairArn] = Optional.Absent,
    fingerprint: Optional[PlaybackKeyPairFingerprint] = Optional.Absent,
    name: Optional[PlaybackKeyPairName] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivs.model.PlaybackKeyPair = {
    import PlaybackKeyPair.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivs.model.PlaybackKeyPair
      .builder()
      .optionallyWith(
        arn.map(value => PlaybackKeyPairArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        fingerprint.map(value =>
          PlaybackKeyPairFingerprint.unwrap(value): java.lang.String
        )
      )(_.fingerprint)
      .optionallyWith(
        name.map(value => PlaybackKeyPairName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ivs.model.PlaybackKeyPair.ReadOnly =
    zio.aws.ivs.model.PlaybackKeyPair.wrap(buildAwsValue())
}
object PlaybackKeyPair {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivs.model.PlaybackKeyPair
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivs.model.PlaybackKeyPair =
      zio.aws.ivs.model.PlaybackKeyPair(
        arn.map(value => value),
        fingerprint.map(value => value),
        name.map(value => value),
        tags.map(value => value)
      )
    def arn: Optional[PlaybackKeyPairArn]
    def fingerprint: Optional[PlaybackKeyPairFingerprint]
    def name: Optional[PlaybackKeyPairName]
    def tags: Optional[Map[TagKey, TagValue]]
    def getArn: ZIO[Any, AwsError, PlaybackKeyPairArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getFingerprint: ZIO[Any, AwsError, PlaybackKeyPairFingerprint] =
      AwsError.unwrapOptionField("fingerprint", fingerprint)
    def getName: ZIO[Any, AwsError, PlaybackKeyPairName] =
      AwsError.unwrapOptionField("name", name)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivs.model.PlaybackKeyPair
  ) extends zio.aws.ivs.model.PlaybackKeyPair.ReadOnly {
    override val arn: Optional[PlaybackKeyPairArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.ivs.model.primitives.PlaybackKeyPairArn(value))
    override val fingerprint: Optional[PlaybackKeyPairFingerprint] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fingerprint())
        .map(value =>
          zio.aws.ivs.model.primitives.PlaybackKeyPairFingerprint(value)
        )
    override val name: Optional[PlaybackKeyPairName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.ivs.model.primitives.PlaybackKeyPairName(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.ivs.model.primitives
              .TagKey(key) -> zio.aws.ivs.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivs.model.PlaybackKeyPair
  ): zio.aws.ivs.model.PlaybackKeyPair.ReadOnly = new Wrapper(impl)
}
