package zio.aws.ivs.model
import zio.aws.ivs.model.primitives.PaginationToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListChannelsResponse(
    channels: Iterable[zio.aws.ivs.model.ChannelSummary],
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivs.model.ListChannelsResponse = {
    import ListChannelsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivs.model.ListChannelsResponse
      .builder()
      .channels(channels.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ivs.model.ListChannelsResponse.ReadOnly =
    zio.aws.ivs.model.ListChannelsResponse.wrap(buildAwsValue())
}
object ListChannelsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivs.model.ListChannelsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivs.model.ListChannelsResponse =
      zio.aws.ivs.model.ListChannelsResponse(
        channels.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def channels: List[zio.aws.ivs.model.ChannelSummary.ReadOnly]
    def nextToken: Optional[PaginationToken]
    def getChannels
        : ZIO[Any, Nothing, List[zio.aws.ivs.model.ChannelSummary.ReadOnly]] =
      ZIO.succeed(channels)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivs.model.ListChannelsResponse
  ) extends zio.aws.ivs.model.ListChannelsResponse.ReadOnly {
    override val channels: List[zio.aws.ivs.model.ChannelSummary.ReadOnly] =
      impl
        .channels()
        .asScala
        .map { item =>
          zio.aws.ivs.model.ChannelSummary.wrap(item)
        }
        .toList
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ivs.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivs.model.ListChannelsResponse
  ): zio.aws.ivs.model.ListChannelsResponse.ReadOnly = new Wrapper(impl)
}
