package zio.aws.ivs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class IngestConfiguration(
    audio: Optional[zio.aws.ivs.model.AudioConfiguration] = Optional.Absent,
    video: Optional[zio.aws.ivs.model.VideoConfiguration] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivs.model.IngestConfiguration = {
    import IngestConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivs.model.IngestConfiguration
      .builder()
      .optionallyWith(audio.map(value => value.buildAwsValue()))(_.audio)
      .optionallyWith(video.map(value => value.buildAwsValue()))(_.video)
      .build()
  }
  def asReadOnly: zio.aws.ivs.model.IngestConfiguration.ReadOnly =
    zio.aws.ivs.model.IngestConfiguration.wrap(buildAwsValue())
}
object IngestConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivs.model.IngestConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivs.model.IngestConfiguration =
      zio.aws.ivs.model.IngestConfiguration(
        audio.map(value => value.asEditable),
        video.map(value => value.asEditable)
      )
    def audio: Optional[zio.aws.ivs.model.AudioConfiguration.ReadOnly]
    def video: Optional[zio.aws.ivs.model.VideoConfiguration.ReadOnly]
    def getAudio
        : ZIO[Any, AwsError, zio.aws.ivs.model.AudioConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("audio", audio)
    def getVideo
        : ZIO[Any, AwsError, zio.aws.ivs.model.VideoConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("video", video)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivs.model.IngestConfiguration
  ) extends zio.aws.ivs.model.IngestConfiguration.ReadOnly {
    override val audio
        : Optional[zio.aws.ivs.model.AudioConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.audio())
        .map(value => zio.aws.ivs.model.AudioConfiguration.wrap(value))
    override val video
        : Optional[zio.aws.ivs.model.VideoConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.video())
        .map(value => zio.aws.ivs.model.VideoConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivs.model.IngestConfiguration
  ): zio.aws.ivs.model.IngestConfiguration.ReadOnly = new Wrapper(impl)
}
