package zio.aws.ivs.model
import zio.aws.ivs.model.primitives.StreamKeyArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetStreamKeyRequest(arn: StreamKeyArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivs.model.GetStreamKeyRequest = {
    import GetStreamKeyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivs.model.GetStreamKeyRequest
      .builder()
      .arn(StreamKeyArn.unwrap(arn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ivs.model.GetStreamKeyRequest.ReadOnly =
    zio.aws.ivs.model.GetStreamKeyRequest.wrap(buildAwsValue())
}
object GetStreamKeyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivs.model.GetStreamKeyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivs.model.GetStreamKeyRequest =
      zio.aws.ivs.model.GetStreamKeyRequest(arn)
    def arn: StreamKeyArn
    def getArn: ZIO[Any, Nothing, StreamKeyArn] = ZIO.succeed(arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivs.model.GetStreamKeyRequest
  ) extends zio.aws.ivs.model.GetStreamKeyRequest.ReadOnly {
    override val arn: StreamKeyArn =
      zio.aws.ivs.model.primitives.StreamKeyArn(impl.arn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivs.model.GetStreamKeyRequest
  ): zio.aws.ivs.model.GetStreamKeyRequest.ReadOnly = new Wrapper(impl)
}
