package zio.aws.ivs.model
import zio.aws.ivs.model.primitives.ChannelArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetChannelRequest(arn: ChannelArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivs.model.GetChannelRequest = {
    import GetChannelRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivs.model.GetChannelRequest
      .builder()
      .arn(ChannelArn.unwrap(arn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ivs.model.GetChannelRequest.ReadOnly =
    zio.aws.ivs.model.GetChannelRequest.wrap(buildAwsValue())
}
object GetChannelRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivs.model.GetChannelRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivs.model.GetChannelRequest =
      zio.aws.ivs.model.GetChannelRequest(arn)
    def arn: ChannelArn
    def getArn: ZIO[Any, Nothing, ChannelArn] = ZIO.succeed(arn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivs.model.GetChannelRequest
  ) extends zio.aws.ivs.model.GetChannelRequest.ReadOnly {
    override val arn: ChannelArn =
      zio.aws.ivs.model.primitives.ChannelArn(impl.arn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivs.model.GetChannelRequest
  ): zio.aws.ivs.model.GetChannelRequest.ReadOnly = new Wrapper(impl)
}
