package zio.aws.ivs.model
import scala.jdk.CollectionConverters._
sealed trait ChannelType {
  def unwrap: software.amazon.awssdk.services.ivs.model.ChannelType
}
object ChannelType {
  def wrap(
      value: software.amazon.awssdk.services.ivs.model.ChannelType
  ): zio.aws.ivs.model.ChannelType = value match {
    case software.amazon.awssdk.services.ivs.model.ChannelType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ivs.model.ChannelType.BASIC =>
      val r = BASIC
      r
    case software.amazon.awssdk.services.ivs.model.ChannelType.STANDARD =>
      val r = STANDARD
      r
    case software.amazon.awssdk.services.ivs.model.ChannelType.ADVANCED_SD =>
      val r = ADVANCED_SD
      r
    case software.amazon.awssdk.services.ivs.model.ChannelType.ADVANCED_HD =>
      val r = ADVANCED_HD
      r
  }
  case object unknownToSdkVersion extends zio.aws.ivs.model.ChannelType {
    override def unwrap: software.amazon.awssdk.services.ivs.model.ChannelType =
      software.amazon.awssdk.services.ivs.model.ChannelType.UNKNOWN_TO_SDK_VERSION
  }
  case object BASIC extends zio.aws.ivs.model.ChannelType {
    override def unwrap: software.amazon.awssdk.services.ivs.model.ChannelType =
      software.amazon.awssdk.services.ivs.model.ChannelType.BASIC
  }
  case object STANDARD extends zio.aws.ivs.model.ChannelType {
    override def unwrap: software.amazon.awssdk.services.ivs.model.ChannelType =
      software.amazon.awssdk.services.ivs.model.ChannelType.STANDARD
  }
  case object ADVANCED_SD extends zio.aws.ivs.model.ChannelType {
    override def unwrap: software.amazon.awssdk.services.ivs.model.ChannelType =
      software.amazon.awssdk.services.ivs.model.ChannelType.ADVANCED_SD
  }
  case object ADVANCED_HD extends zio.aws.ivs.model.ChannelType {
    override def unwrap: software.amazon.awssdk.services.ivs.model.ChannelType =
      software.amazon.awssdk.services.ivs.model.ChannelType.ADVANCED_HD
  }
}
