package zio.aws.ivs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BatchStartViewerSessionRevocationResponse(
    errors: Optional[
      Iterable[zio.aws.ivs.model.BatchStartViewerSessionRevocationError]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivs.model.BatchStartViewerSessionRevocationResponse = {
    import BatchStartViewerSessionRevocationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivs.model.BatchStartViewerSessionRevocationResponse
      .builder()
      .optionallyWith(
        errors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.errors)
      .build()
  }
  def asReadOnly
      : zio.aws.ivs.model.BatchStartViewerSessionRevocationResponse.ReadOnly =
    zio.aws.ivs.model.BatchStartViewerSessionRevocationResponse
      .wrap(buildAwsValue())
}
object BatchStartViewerSessionRevocationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivs.model.BatchStartViewerSessionRevocationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ivs.model.BatchStartViewerSessionRevocationResponse =
      zio.aws.ivs.model.BatchStartViewerSessionRevocationResponse(
        errors.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def errors: Optional[
      List[zio.aws.ivs.model.BatchStartViewerSessionRevocationError.ReadOnly]
    ]
    def getErrors: ZIO[Any, AwsError, List[
      zio.aws.ivs.model.BatchStartViewerSessionRevocationError.ReadOnly
    ]] = AwsError.unwrapOptionField("errors", errors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivs.model.BatchStartViewerSessionRevocationResponse
  ) extends zio.aws.ivs.model.BatchStartViewerSessionRevocationResponse.ReadOnly {
    override val errors: Optional[
      List[zio.aws.ivs.model.BatchStartViewerSessionRevocationError.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.errors())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ivs.model.BatchStartViewerSessionRevocationError.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivs.model.BatchStartViewerSessionRevocationResponse
  ): zio.aws.ivs.model.BatchStartViewerSessionRevocationResponse.ReadOnly =
    new Wrapper(impl)
}
