package zio.aws.ivs.model
import zio.aws.ivs.model.primitives.{
  ViewerId,
  ErrorMessage,
  ErrorCode,
  ChannelArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BatchStartViewerSessionRevocationError(
    channelArn: ChannelArn,
    code: Optional[ErrorCode] = Optional.Absent,
    message: Optional[ErrorMessage] = Optional.Absent,
    viewerId: ViewerId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivs.model.BatchStartViewerSessionRevocationError = {
    import BatchStartViewerSessionRevocationError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivs.model.BatchStartViewerSessionRevocationError
      .builder()
      .channelArn(ChannelArn.unwrap(channelArn): java.lang.String)
      .optionallyWith(
        code.map(value => ErrorCode.unwrap(value): java.lang.String)
      )(_.code)
      .optionallyWith(
        message.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.message)
      .viewerId(ViewerId.unwrap(viewerId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.ivs.model.BatchStartViewerSessionRevocationError.ReadOnly =
    zio.aws.ivs.model.BatchStartViewerSessionRevocationError
      .wrap(buildAwsValue())
}
object BatchStartViewerSessionRevocationError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivs.model.BatchStartViewerSessionRevocationError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivs.model.BatchStartViewerSessionRevocationError =
      zio.aws.ivs.model.BatchStartViewerSessionRevocationError(
        channelArn,
        code.map(value => value),
        message.map(value => value),
        viewerId
      )
    def channelArn: ChannelArn
    def code: Optional[ErrorCode]
    def message: Optional[ErrorMessage]
    def viewerId: ViewerId
    def getChannelArn: ZIO[Any, Nothing, ChannelArn] = ZIO.succeed(channelArn)
    def getCode: ZIO[Any, AwsError, ErrorCode] =
      AwsError.unwrapOptionField("code", code)
    def getMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("message", message)
    def getViewerId: ZIO[Any, Nothing, ViewerId] = ZIO.succeed(viewerId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivs.model.BatchStartViewerSessionRevocationError
  ) extends zio.aws.ivs.model.BatchStartViewerSessionRevocationError.ReadOnly {
    override val channelArn: ChannelArn =
      zio.aws.ivs.model.primitives.ChannelArn(impl.channelArn())
    override val code: Optional[ErrorCode] = zio.aws.core.internal
      .optionalFromNullable(impl.code())
      .map(value => zio.aws.ivs.model.primitives.ErrorCode(value))
    override val message: Optional[ErrorMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => zio.aws.ivs.model.primitives.ErrorMessage(value))
    override val viewerId: ViewerId =
      zio.aws.ivs.model.primitives.ViewerId(impl.viewerId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivs.model.BatchStartViewerSessionRevocationError
  ): zio.aws.ivs.model.BatchStartViewerSessionRevocationError.ReadOnly =
    new Wrapper(impl)
}
