package zio.aws.ivs.model
import zio.aws.ivs.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AudioConfiguration(
    channels: Optional[Integer] = Optional.Absent,
    codec: Optional[String] = Optional.Absent,
    sampleRate: Optional[Integer] = Optional.Absent,
    targetBitrate: Optional[Integer] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ivs.model.AudioConfiguration = {
    import AudioConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ivs.model.AudioConfiguration
      .builder()
      .optionallyWith(channels.map(value => value: java.lang.Long))(_.channels)
      .optionallyWith(codec.map(value => value: java.lang.String))(_.codec)
      .optionallyWith(sampleRate.map(value => value: java.lang.Long))(
        _.sampleRate
      )
      .optionallyWith(targetBitrate.map(value => value: java.lang.Long))(
        _.targetBitrate
      )
      .build()
  }
  def asReadOnly: zio.aws.ivs.model.AudioConfiguration.ReadOnly =
    zio.aws.ivs.model.AudioConfiguration.wrap(buildAwsValue())
}
object AudioConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ivs.model.AudioConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ivs.model.AudioConfiguration =
      zio.aws.ivs.model.AudioConfiguration(
        channels.map(value => value),
        codec.map(value => value),
        sampleRate.map(value => value),
        targetBitrate.map(value => value)
      )
    def channels: Optional[Integer]
    def codec: Optional[String]
    def sampleRate: Optional[Integer]
    def targetBitrate: Optional[Integer]
    def getChannels: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("channels", channels)
    def getCodec: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("codec", codec)
    def getSampleRate: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("sampleRate", sampleRate)
    def getTargetBitrate: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("targetBitrate", targetBitrate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ivs.model.AudioConfiguration
  ) extends zio.aws.ivs.model.AudioConfiguration.ReadOnly {
    override val channels: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.channels())
      .map(value => value: Integer)
    override val codec: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.codec())
      .map(value => value: String)
    override val sampleRate: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.sampleRate())
      .map(value => value: Integer)
    override val targetBitrate: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.targetBitrate())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ivs.model.AudioConfiguration
  ): zio.aws.ivs.model.AudioConfiguration.ReadOnly = new Wrapper(impl)
}
